import { MergedRollupOptions } from 'rollup';
export interface HvigorOptions extends MergedRollupOptions {
    /**
     * 是否禁用生成 bundle。默认为 false 不禁用。
     */
    disableGenerateBundle?: boolean;
    /**
     * 是否落盘 bundle 文件。默认为 true 落盘文件。
     */
    writeBundle?: boolean;
    /**
     * enable filesystem cache
     * if set to true will write the last build bundle cache to file,
     * the next build will try to use the bundle cache.
     * default is false
     */
    enableFileSystemCache?: boolean;
    /**
     * cacheDirectory default is node_module/.cache/hvigor_compile
     * only valid when enableFileSystemCache is set true
     */
    cacheDirectory?: string;
    /**
     * 是否开启watch模式 默认是'false'
     */
    watchMode?: 'true' | 'false';
    /**
     * 打点开始
     *
     * @param name 事件名称
     */
    startEvent: (eventName: string) => string;
    /**
     * 打点结束
     *
     * @param eventId 事件id
     */
    endEvent: (eventId: string) => void;
    /**
     * watch模式下不支持改变的文件集合
     */
    unsupportedChangedFiles?: string[];
}
