export declare const CONTINUAL_EVENT = "continual";
export declare const DURATION_EVENT = "duration";
declare type CompileEventType = 'duration' | 'continual';
/**
 * 对应hvigor中的EventHead
 */
export interface EventHead {
    id: string;
    name: string;
    description: string;
    type: CompileEventType;
}
/**
 * 对应hvigor中的EventBody
 */
export interface EventBody {
    pid: number;
    tid: string;
    startTime: number;
    endTime?: number;
}
/**
 * 对应hvigor中的DurationEventState
 */
export declare type CompileEventState = 'created' | 'beginning' | 'running' | 'failed' | 'success' | 'warn';
/**
 * 对应hvigor中的DurationEventAdditional
 */
export interface CompileEventAdditional {
    category?: string;
    parent?: string;
    children: string[];
    state: CompileEventState;
    fromHook: boolean;
    totalTime: number;
    frequency: number;
}
/**
 * 编译过程内部的事件，需要转化为hvigor中的DurationEvent/ContinualEvent
 *
 * @since 2023/6/2
 */
export declare class CompileEvent {
    private head;
    private body;
    private additional;
    constructor(id: string, name: string, pid: number, tid: string, totalTime: number, frequency: number, fromHook?: boolean);
    isFromHook(): boolean;
    start(time?: number): this;
    stop(state?: CompileEventState, time?: number): void;
    /**
     * 针对hook内注册的异步操作对应的事件开始计时
     *
     * @param time 自定义的开始时间
     */
    startAsyncEvent(time?: number): this;
    /**
     * 针对hook内注册的异步操作对应的事件结束计时
     *
     * @param state 自定义事件状态
     * @param time 自定义结束时间
     */
    stopAsyncEvent(state?: CompileEventState, time?: number): void;
    setDescription(description: string): this;
    setState(state: CompileEventState): this;
    setCategory(category: string): this;
    getCategory(): string | undefined;
    createSubEvent(name: string): CompileEvent;
    setStartTime(time?: number): this;
    getStartTime(): number;
    setEndTime(time?: number): this;
    getEndTime(): number | undefined;
    addChild(child: string): void;
    setChildren(children: string[]): void;
    setParent(parent: string): this;
    getParent(): string | undefined;
    getName(): string;
    getId(): string;
    getChildren(): string[];
    getTid(): string;
    setTid(tid: string): this;
    setName(name: string): void;
    setType(type: CompileEventType): void;
    inCreFrequency(): this;
    inCreTotalTime(event: CompileEvent): this;
}
export {};
