"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArkUIXLicenseManager = void 0;
const license_manager_1 = require("../../core/license/license-manager");
const error_tip_1 = require("../../core/api/error-tip");
const arkuix_biz_util_1 = require("../util/arkuix-biz-util");
const utils_1 = require("../../core/util/utils");
const arkuix_sdk_info_handler_1 = require("../api/arkuix-sdk-info-handler");
class ArkUIXLicenseManager extends license_manager_1.AbstractLicenseManager {
    constructor(sdkSettings, netClient) {
        super();
        this._sdkSettings = sdkSettings;
        this._netClient = netClient;
    }
    getReadLocalHashErrorMessage(licensesLocation) {
        return new error_tip_1.ErrorTip('Failed to read the license file.', 'The license file may be corrupted or missing.', `Delete the ${licensesLocation} folder and \
      go to ${(0, arkuix_sdk_info_handler_1.getArkUIXMenuLocation)()} to download any SDK. Open SDK Manager`).getMessage();
    }
    getLicensesRootLocation() {
        return this._sdkSettings.getLocation();
    }
    retrieveLicenses(licenseIds, progress) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const grsService = yield this._sdkSettings.getGrsService();
                const queryLicenseUrl = (0, arkuix_biz_util_1.getQueryLicenseUrl)(grsService);
                const data = yield this._netClient.doPost(queryLicenseUrl, progress, this._createReqBody(licenseIds));
                const resultMap = new Map();
                if (data) {
                    for (const arkUIXLicenseRspDto of data) {
                        const licenseContent = yield this._netClient.doGet(arkUIXLicenseRspDto.url, progress);
                        if (!(0, utils_1.isEmpty)(licenseContent)) {
                            const license = {
                                id: arkUIXLicenseRspDto.licenseId,
                                content: licenseContent,
                            };
                            resultMap.set(arkUIXLicenseRspDto.licenseId, license);
                        }
                    }
                }
                return resultMap;
            }
            catch (e) {
                progress.warn(`Failed to request ArkUI-X SDK license, ${e}`);
            }
            return new Map();
        });
    }
    _createReqBody(licenseIds) {
        return {
            licenseIds: licenseIds,
        };
    }
}
exports.ArkUIXLicenseManager = ArkUIXLicenseManager;
