import { AbstractLocalComponentLoader } from '../../core/loader/abstract-local-component-loader';
import { Component } from '../../core/api/component';
import { Progress } from '../../core/log/progress';
export declare class ArkUIXLocalComponentLoader extends AbstractLocalComponentLoader {
    /**
     * 扫描文件夹深度的最大值
     * @private
     */
    private static readonly _MAX_SCAN_DEPTH;
    private _inCompatibleComponents;
    constructor(sdkRoot: string, progress?: Progress);
    /**
     * parseSdks
     * @param potentialUniPackages 扫描出来的元数据文件
     * @protected
     * @return Component[] Component数组
     */
    protected parseSdks(potentialUniPackages: string[]): Component[];
    /**
     * 将json字符串转换为ComponentDto类
     * @param jsonObject
     * @param uniPackage
     * @protected
     */
    private convertComponent;
    private configMeta;
    private _isDifferentMetaVersion;
    private _isComponentInWrongPlace;
    private _getExpectedLocation;
    protected getUniPackageName(): string;
    protected getSdkRoot(): string;
    /**
     * 获取不兼容的sdk
     */
    getInCompatibleComponents(): Array<Component>;
}
