"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkException = void 0;
const utils_1 = require("../util/utils");
/**
 * sdklib库对外抛出的异常
 */
class SdkException extends Error {
    constructor(msg = '', errorTip) {
        if ((0, utils_1.isEmpty)(msg)) {
            super(errorTip.getMessage());
        }
        else {
            super(msg);
        }
        this._errorTip = errorTip;
    }
    getErrorTip() {
        return this._errorTip;
    }
}
exports.SdkException = SdkException;
