"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkInfoSettings = void 0;
const grs_service_1 = require("../grs/grs-service");
const os_type_util_1 = require("../util/os-type-util");
const utils_1 = require("../util/utils");
const common_net_client_1 = require("../net/common-net-client");
class SdkInfoSettings {
    constructor(sdkInfoConfig) {
        this._countryCode = 'CN';
        this._sdkInfoConfig = sdkInfoConfig;
        this._osType = (0, os_type_util_1.getOsType)();
        const countryCode = process.env['user.country'];
        if (!(0, utils_1.isEmpty)(countryCode)) {
            this._countryCode = countryCode;
        }
    }
    getLocation() {
        return this._sdkInfoConfig.sdkRoot;
    }
    getNpmConfig() {
        return this._sdkInfoConfig.npmConfig;
    }
    getNpmHome() {
        return this._sdkInfoConfig.nodeHome;
    }
    getGrsService() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._grsService) {
                return this._grsService;
            }
            this._grsService = yield grs_service_1.GrsService.getInstance(this.getNetClient());
            return this._grsService;
        });
    }
    getOsType() {
        return this._osType;
    }
    getCountry() {
        return this._countryCode;
    }
    getNetClient() {
        if (this._netClient) {
            return this._netClient;
        }
        this._netClient = new common_net_client_1.CommonNetClient(this._sdkInfoConfig.getSdkProxy());
        return this._netClient;
    }
}
exports.SdkInfoSettings = SdkInfoSettings;
