"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GrsService = void 0;
const utils_1 = require("../util/utils");
const component_contants_1 = require("../constants/component-contants");
const simple_progress_1 = require("../log/simple-progress");
const KEY_SERVICE = 'services';
class GrsService {
    constructor(netClient) {
        this._getGrs0 = (param) => __awaiter(this, void 0, void 0, function* () {
            try {
                const result = yield this._netClient.doPost(this._assembleUrl(param), new simple_progress_1.SimpleProgress(), '', this._createHeader());
                const grs = JSON.parse(JSON.stringify(result));
                this._grsService = grs[KEY_SERVICE];
            }
            catch (error) {
                return false;
            }
            return true;
        });
        this._assembleUrl = (param) => {
            return `${param.url}?app_name=devecostudio&issue_country=${(0, utils_1.isEmpty)(param.issueCountry) ? 'CN' : param.issueCountry}`;
        };
        this._createHeader = () => {
            return {
                'User-Agent': 'com.huawei.deveco.common-grs/0.1 (Windows;Linux;Mac) Deveco-grs/-1'
            };
        };
        this.getUrl = (serviceName, key) => {
            var _b, _c;
            return (_c = (_b = this._grsService) === null || _b === void 0 ? void 0 : _b[serviceName]) === null || _c === void 0 ? void 0 : _c[key];
        };
        this._getGrs = () => __awaiter(this, void 0, void 0, function* () {
            const _param = this._getGrsParam();
            if (_param === null || _param === void 0 ? void 0 : _param.url) {
                yield this._getGrs0(_param);
            }
            else {
                for (const grsUrl of component_contants_1.defaultGrsUrls) {
                    const host = yield this._getGrs0({ url: grsUrl, issueCountry: _param === null || _param === void 0 ? void 0 : _param.issueCountry });
                    if (host) {
                        return;
                    }
                }
            }
        });
        this._getGrsParam = () => {
            return {
                url: process.env['grs_url'],
                issueCountry: process.env['user.country'],
            };
        };
        this._netClient = netClient;
    }
}
exports.GrsService = GrsService;
_a = GrsService;
GrsService.getInstance = (netClient) => __awaiter(void 0, void 0, void 0, function* () {
    const grsService = new GrsService(netClient);
    yield grsService._getGrs();
    return grsService;
});
