import { Progress } from '../log/progress';
export interface LicenseManager {
    /**
     * 给定license id的集合，查找其中尚未接受的licenses
     * @param licenseIds
     * @param progress
     */
    findUnacceptedLicenses(licenseIds: string[], progress: Progress): Promise<License[] | undefined>;
    /**
     * 获取云端的license信息
     * @param licenseIds
     * @param progress
     */
    retrieveLicenses(licenseIds: string[], progress: Progress): Promise<Map<string, License>>;
}
export declare abstract class AbstractLicenseManager implements LicenseManager {
    findUnacceptedLicenses(licenseIds: string[], progress: Progress): Promise<License[] | undefined>;
    private checkLicense;
    private hasAccepted;
    private hashContent;
    private readLocalHash;
    private getLicensesLocation;
    /**
     * 获取存放license文件的根目录
     * @protected
     */
    protected abstract getLicensesRootLocation(): string;
    /**
     * 获取本地license信息失败的错误提示
     * @param licensesLocation
     * @protected
     */
    protected abstract getReadLocalHashErrorMessage(licensesLocation: string): string;
    abstract retrieveLicenses(licenseIds: string[], progress: Progress): Promise<Map<string, License>>;
}
export interface License {
    id: string;
    content: string;
}
