"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractComponentTask = void 0;
const path_1 = __importDefault(require("path"));
const sdk_exception_1 = require("../api/sdk-exception");
const error_tip_1 = require("../api/error-tip");
const tempDir = '.temp';
class AbstractComponentTask {
    constructor(component) {
        this.component = component;
    }
    execute(progress) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                progress.info(`Install task started: ${this.getComponent().getFullName()}`);
                yield this.prepare(progress);
                yield this.complete(progress);
                progress.info(`Install task finished: ${this.getComponent().getFullName()}`);
            }
            catch (error) {
                if (error instanceof sdk_exception_1.SdkException) {
                    throw error; // 自定义的异常直接往外抛
                }
                else { // 未知的异常添加提示语后往外抛出自定义的异常
                    progress.error(`Install task encountered an unknown error: ${this.component.getFullName()}`);
                    throw new sdk_exception_1.SdkException('', new error_tip_1.ErrorTip('', 'An unknown error occurred.', 'Choose Help > Show Log in Explorer to obtain logs, and then choose Help > Contact Support for technical assistance.'));
                }
            }
            return Promise.resolve();
        });
    }
    getRootWorkDir() {
        return path_1.default.resolve(this.getSdkRoot(), tempDir);
    }
    getWorkDir() {
        return path_1.default.resolve(this.getRootWorkDir(), this.component.getPath());
    }
    prepare(progress) {
        progress.debug('prepare');
        return Promise.resolve(undefined);
    }
    complete(progress) {
        progress.debug('complete');
        return Promise.resolve(undefined);
    }
}
exports.AbstractComponentTask = AbstractComponentTask;
