import { Progress } from '../log/progress';
import { AbstractComponentTask } from './abstract-component-task';
import { InstallTask } from './install-task';
import { Component } from '../api/component';
import { SdkSettings } from '../domain/sdk-settings';
export declare abstract class NpmInstallTask extends AbstractComponentTask implements InstallTask {
    private _env;
    private _installTask;
    protected constructor(installTask: InstallTask);
    prepare(progress: Progress): Promise<void>;
    complete(progress: Progress): Promise<void>;
    private _needNpmInstall;
    private _doNpmInstall;
    private _installDependencies;
    private _verifySdkJs;
    private _runCmd;
    private _addCommonNpmCmdEnv;
    private _addNpmBinPathToEnv;
    private _addNpmRegistryIfNeed;
    /**
     * npm 7.x以上的版本执行npm install会有问题，需要做一些特殊处理
     * @private
     */
    private _addCompatibleLaterNodeVersionConfig;
    /**
     * npm -v命令有可能出现多行，而且最后一行才是版本号，如果npmrc里面有配置一些不兼容的参数，那么前面会出现告警提示，所以要取最后一行
     * @param npmVersion
     */
    private _processNpmVersion;
    /**
     * SDK的package-lock.json里面有resolved字段，该字段描述的是某个npm包的下载地址
     * npm6.x版本在执行npm install的时候不会关注resolved字段，下载npm包是从配置的registry仓里面获取
     * npm7.x以上版本在执行npm install的时候会关注resolved字段，下载npm包从resolved字段获取，此时用户配置的registry没有生效
     * 由于地址写死成外网华为npm仓，用户无法通过切换registry来下载npm依赖，会导致npm install失败
     *
     * 这里采用的方案是在npm install之前将所有的package-lock.json文件里面的resolved字段值替换成false，
     * 这样npm就可以去用户配置的registry仓库下载依赖了
     * @param acePath 需要执行npm install的根目录
     * @private
     */
    private _processPackageLock;
    private getNpmBinPath;
    private npmInstall;
    /**
     * 获取执行npm install命令的目录
     * @protected
     */
    protected abstract getRunNpmInstallPath(): string;
    getComponent(): Component;
    getWorkDir(): string;
    getRootWorkDir(): string;
    getSdkSettings(): SdkSettings;
    getSdkRoot(): string;
    getTempComponentPath(): string;
    download(progress: Progress): Promise<string>;
}
