import { Progress } from '../log/progress';
import { ErrorTip } from '../api/error-tip';
import { ComponentTask } from './component-task';
import { Component } from '../api/component';
import { AbstractComponentTask } from './abstract-component-task';
export declare abstract class SingleTaskWrapper extends AbstractComponentTask {
    private readonly LCK;
    private readonly _componentTask;
    protected constructor(componentTask: ComponentTask);
    execute: (progress: Progress) => Promise<void>;
    /**
     * 有重复任务执行时的报错提示
     * @param lockFile
     * @protected
     */
    protected abstract getDuplicateTaskErrorTip(lockFile: string): ErrorTip;
    private _releaseLock;
    private _closeLock;
    private _isLockValid;
    private _cleanWorkDirWhenEmpty;
    getComponent(): Component;
    getSdkRoot(): string;
}
