/// <reference types="node" />
import { PathLike, Stats } from 'fs';
/**
 * 校验路径是否有写权限
 * @param path
 */
export declare function isWritable(path: PathLike): boolean;
/**
 * 当文件不存在时,fs.statSync方法会抛异常,需要catch一下
 * @param filePath
 * @private
 */
export declare function fsStateSync(filePath: string): Stats | undefined;
/**
 * 创建当前路径的上一级目录
 * @param location
 */
export declare function ensureParentDir(location: string): void;
/**
 * 异步创建当前路径的上一级目录
 * @param location
 */
export declare function ensureParentDirAsync(location: string): Promise<string | undefined>;
/**
 * 从一个文件夹目录中寻找需要的文件
 * @param rootPath 文件夹根目录
 * @param filter 文件过滤器
 */
export declare function findFiles(rootPath: string, filter: (fileName: string) => boolean): Promise<string[]>;
