"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findFiles = exports.ensureParentDirAsync = exports.ensureParentDir = exports.fsStateSync = exports.isWritable = void 0;
const fs_1 = __importStar(require("fs"));
const path_1 = __importDefault(require("path"));
/**
 * 校验路径是否有写权限
 * @param path
 */
function isWritable(path) {
    try {
        fs_1.default.accessSync(path, fs_1.constants.W_OK);
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.isWritable = isWritable;
/**
 * 当文件不存在时,fs.statSync方法会抛异常,需要catch一下
 * @param filePath
 * @private
 */
function fsStateSync(filePath) {
    try {
        return fs_1.default.statSync(filePath);
    }
    catch (e) {
        return undefined;
    }
}
exports.fsStateSync = fsStateSync;
/**
 * 创建当前路径的上一级目录
 * @param location
 */
function ensureParentDir(location) {
    const parentDir = path_1.default.resolve(location, '..');
    if (!fs_1.default.existsSync(parentDir)) {
        fs_1.default.mkdirSync(parentDir, { recursive: true });
    }
}
exports.ensureParentDir = ensureParentDir;
/**
 * 异步创建当前路径的上一级目录
 * @param location
 */
function ensureParentDirAsync(location) {
    return __awaiter(this, void 0, void 0, function* () {
        const parentDir = path_1.default.resolve(location, '..');
        if (!fs_1.default.existsSync(parentDir)) {
            return fs_1.default.promises.mkdir(parentDir, { recursive: true });
        }
        return Promise.resolve(parentDir);
    });
}
exports.ensureParentDirAsync = ensureParentDirAsync;
/**
 * 从一个文件夹目录中寻找需要的文件
 * @param rootPath 文件夹根目录
 * @param filter 文件过滤器
 */
function findFiles(rootPath, filter) {
    return __awaiter(this, void 0, void 0, function* () {
        const stats = yield fs_1.default.promises.stat(rootPath);
        if (!stats.isDirectory()) {
            const fileName = path_1.default.basename(rootPath);
            if (filter(fileName)) {
                return [fileName];
            }
            return [];
        }
        const result = [];
        const stack = [];
        stack.push(rootPath);
        while (stack.length !== 0) {
            const absolutePath = stack.pop();
            for (const dirent of yield fs_1.default.promises.readdir(absolutePath, { withFileTypes: true })) {
                if (dirent.isDirectory()) {
                    stack.push(path_1.default.join(absolutePath, dirent.name));
                    continue;
                }
                if (filter(dirent.name)) {
                    result.push(path_1.default.join(absolutePath, dirent.name));
                }
            }
        }
        return result;
    });
}
exports.findFiles = findFiles;
