"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNotEmpty = exports.isEmpty = exports.compareVersion = void 0;
/**
 * 比较版本号的方法,版本号的格式是以[0-9]+\.的形式组成，例如1.0.0.0
 * 如果字符串不是以上面的规则组成，则直接进行字符串比较
 * @param first
 * @param second
 * @return number 返回结果大于0表示first比second大，
 * 等于0表示相等，小于0表示first比second小
 */
function compareVersion(first, second) {
    const version1 = first.split('.');
    const version2 = second.split('.');
    for (let i = 0; i < version1.length; i++) {
        const number1 = Number(version1[i]);
        const number2 = Number(version2[i]);
        if (Number.isNaN(number1) || Number.isNaN(number2)) {
            return first.localeCompare(second);
        }
        const result = number1 - number2;
        if (result === 0) {
            continue;
        }
        else if (result > 0) {
            return 1;
        }
        else {
            return -1;
        }
    }
    return 0;
}
exports.compareVersion = compareVersion;
/**
 * 判断值是否为null、undefined、''
 * @param value
 */
function isEmpty(value) {
    return value === null || value === undefined || value.length === 0;
}
exports.isEmpty = isEmpty;
/**
 * 判断值是否为null、undefined、''
 * @param value
 */
function isNotEmpty(value) {
    return !isEmpty(value);
}
exports.isNotEmpty = isNotEmpty;
