import { AbstractLocalComponentLoader } from '../../core/loader/abstract-local-component-loader';
import { Progress } from '../../core/log/progress';
import { Component } from '../../core/api/component';
export declare class OhLocalComponentLoader extends AbstractLocalComponentLoader {
    private static readonly _MAX_SCAN_DEPTH;
    private _inCompatibleComponents;
    constructor(sdkRoot: string, progress?: Progress);
    /**
     * 将扫描到的文件转换为Component
     * @param potentialUniPackages
     * @protected
     */
    protected parseSdks(potentialUniPackages: string[]): Component[];
    /**
     * 将json字符串转换为ComponentDto类
     * @param jsonObject
     * @protected
     */
    private convertComponent;
    /**
     * 配置json里面的meta字段信息,需要子类重写
     * @param jsonObject
     * @param dto OhComponentDto
     * @protected
     */
    private configMeta;
    private _isSameMetaVersion;
    /**
     * 校验sdk的路径
     *
     * @param component
     * @protected
     */
    private _isComponentInRightPlace;
    private _getExpectedLocation;
    protected getUniPackageName(): string;
    protected getSdkRoot(): string;
    /**
     * 获取不兼容的sdk
     */
    getInCompatibleComponents(): Array<Component>;
}
