import { Component } from '../../core/api/component';
import { AbstractComponentLoader } from '../../core/loader/abstract-component-loader';
import { SdkSettings } from '../../core/domain/sdk-settings';
import { SimpleProgress } from '../../core/log/simple-progress';
import { CommonNetClient } from '../../core/net/common-net-client';
export declare class OhRemoteComponentLoader extends AbstractComponentLoader {
    private readonly _settings;
    private _netClient;
    constructor(settings: SdkSettings, netClient: CommonNetClient, progress?: SimpleProgress);
    load(): Promise<Component[]>;
    private configComponent;
    private _configApiVersion;
    /**
     * 判断同一apiVersion下的sdk是否存在冗余数据
     *
     * @param component
     * @param remotes
     */
    protected notDuplicate: (component: Component, remotes: Map<string, Component>) => boolean;
}
