"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OhRemoteComponentLoader = void 0;
const abstract_component_loader_1 = require("../../core/loader/abstract-component-loader");
const oh_biz_util_1 = require("../util/oh-biz-util");
const simple_progress_1 = require("../../core/log/simple-progress");
const oh_component_constants_1 = require("../const/oh-component-constants");
const component_contants_1 = require("../../core/constants/component-contants");
const oh_component_dto_1 = require("./oh-component-dto");
const os_type_util_1 = require("../../core/util/os-type-util");
class OhRemoteComponentLoader extends abstract_component_loader_1.AbstractComponentLoader {
    constructor(settings, netClient, progress = new simple_progress_1.SimpleProgress()) {
        super(progress);
        /**
         * 判断同一apiVersion下的sdk是否存在冗余数据
         *
         * @param component
         * @param remotes
         */
        this.notDuplicate = (component, remotes) => {
            const key = this.genKey(component);
            const previousComponent = remotes.get(key);
            if (!previousComponent) {
                return true;
            }
            return component.compareTo(previousComponent) > 0;
        };
        this._settings = settings;
        this._netClient = netClient;
    }
    load() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const grsService = yield this._settings.getGrsService();
                if (!grsService) {
                    this.progress.warn('Failed to request remote OpenHarmony SDK, grsService is undefined');
                    return [];
                }
                const queryMetaUrl = (0, oh_biz_util_1.getQueryMetaUrl)(grsService);
                const result = yield this._netClient.doPost(queryMetaUrl, this.progress, {
                    osType: this._settings.getOsType(),
                    osArch: (0, os_type_util_1.getOsArch)(this.progress),
                    supportVersion: oh_component_constants_1.SUPPORT_VERSION,
                });
                const resultData = this.configComponent(result);
                const remotes = new Map();
                resultData.map(ohComponentDto => {
                    if (this.isValidComponent(ohComponentDto) && this.notDuplicate(ohComponentDto, remotes)) {
                        this.addToMap(remotes, ohComponentDto);
                    }
                    return remotes;
                });
                const sdks = [];
                remotes.forEach(value => sdks.push(value));
                return sdks;
            }
            catch (error) {
                this.progress.warn(error);
            }
            return [];
        });
    }
    configComponent(datas) {
        const result = [];
        for (const data of datas) {
            const dto = new oh_component_dto_1.OhComponentDto();
            Object.assign(dto, data);
            this._configApiVersion(data, dto);
            dto.displayName = this.convertDisplayName(dto);
            dto.location = this.getLocation(dto, this._settings.getLocation());
            const archiveDto = new oh_component_dto_1.OhArchiveDto();
            const archive = data.archive;
            archiveDto.url = archive.url;
            archiveDto.checksum = archive.checksum;
            const size = Number(archive.size);
            if (!Number.isNaN(size)) {
                archiveDto.size = size;
            }
            dto.archive = archiveDto;
            result.push(dto);
        }
        return result;
    }
    _configApiVersion(data, componentDto) {
        const apiVersion = Number(data.apiVersion);
        if (!Number.isNaN(apiVersion)) {
            componentDto.apiVersion = apiVersion;
        }
        if (component_contants_1.ComponentPath.TOOLCHAINS === componentDto.getPath() &&
            oh_component_constants_1.TOOLCHAINS_3_0_0_0_VERSION === componentDto.getVersion()) {
            componentDto.apiVersion = oh_component_constants_1.TOOLCHAINS_3_0_0_0_API7_MAPPING; // 需要迁移的toolchains的apiversion固定设置为7
        }
    }
}
exports.OhRemoteComponentLoader = OhRemoteComponentLoader;
