import { CoreModuleModelImpl } from '../../model/module/core-module-model-impl.js';
import { ModuleModel } from '../../model/module/module-model.js';
import { ProjectBuildProfile } from '../../options/build/project-build-profile.js';
import { LegacyPathInfo } from '../legacy-path-info.js';
import { PathInfo } from '../path-info.js';
export declare class ModulePathInfoIml implements LegacyPathInfo, PathInfo {
    private readonly _curModule;
    private readonly _targetName;
    private readonly _modulePath;
    private readonly _productName;
    private readonly _buildRoot;
    constructor(curModule: ModuleModel, targetName: string, productName: string, buildRoot?: string);
    getPatchDir(): string;
    getObfuscationExportRulePath(): string;
    getIntermediatesJavaDir(): string;
    getIntermediatesClassDir(): string;
    getIntermediatesDexDir(): string;
    getIntermediatesShellClassDir(): string;
    getIntermediatesShellDexDir(): string;
    getIntermediatesShellJavaDir(): string;
    getIntermediatesApkDir(): string;
    getBuildRoot(): string;
    getModuleBuildPath(useDefault?: boolean): string;
    getModuleSrcMainPath(): string;
    getModuleSrcMockPath(): string;
    getModulePath(): string;
    getModuleSrcMainResourceBaseProfilePath(): string;
    getModulePreviewPath(): string;
    getModuleProductPath(useDefault?: boolean): string;
    getModulePreviewProductPath(): string;
    /**
     * .preview/${productName}/intermediates/res/${targetName}
     */
    getModulePreviewIntermediatesResPath(): string;
    /**
     * .preview/${productName}/intermediates/res/${targetName}/resources/base/profile
     */
    getModulePreviewIntermediatesProfilePath(): string;
    getModuleBuildIntermediates(): string;
    getModuleBuildGenerated(): string;
    getModulePreviewBuildGenerated(): string;
    getModuleBuildOutputPath(): string;
    /**
     * 获取模块级别的cache下的remote_hsp路径
     */
    getModuleRemoteHspPath(): string;
    getIntermediatesMergeRes(): string;
    getIntermediatesMergeFile(): string;
    getIntermediatesMergeProfile(): string;
    getIntermediatesMergeProfileDir(): string;
    getGenerateSourceR(): string;
    getGeneratePmDir(): string;
    getGenerateBuildProfilePath(targetName: string): string;
    getHarGenerateBuildProfilePath(): string;
    getGenerateBuildProfileDir(): string;
    getPreviewGenerateSourceR(): string;
    getIntermediatesProcessProfile(): string;
    getIntermediatesProcessLegacyProfile(): string;
    getIntermediatesRes(): string;
    /**
     * restool编译结果的产物profile的路径
     * 其中resources,base,profile是固定的，是restool中的定义
     *
     * @return ../intermediates/res/{targetName}/res/base/profile
     */
    getIntermediatesResProfilePath(): string;
    getIntermediatesFaAssetsPath(product: ProjectBuildProfile.ProductBuildOpt): string;
    getInterMediatesLoaderOutPath(): string;
    getInterMediatesAssetsPath(): string;
    getInterMediatesLoaderOutLitePath(): string;
    getIntermediatesLoaderPath(): string;
    getIntermediatesApPath(): string;
    getModuleBuildCachePath(): string;
    getIntermediatesMergeLegacyProfile(): string;
    getIntermediatesLegacyManifestJson(): string;
    getIntermediatesPackInfoDir(): string;
    getIntermediatesProcessLibs(): string;
    getIntermediatesStrippedLibsDir(): string;
    getIntermediatesPatch(): string;
    getIntermediatesSysCap(): string;
    getCppOutputDir(): string;
    getNinjaWorkDir(): string;
    getModuleShellDir(): string;
    getShellResourceDir(): string;
    getShellSrcMain(): string;
    getShellBuildResourceDir(): string;
    getIntermediatesCppOutPut(): string;
    getIntermediatesLiteBinSource(): string;
    getModuleBinOutput(): string;
    getIntermediatesLiteSource(): string;
    getIntermediatesTemp(): string;
    /**
     * 获取预览和调试对应的编译参数配置文件路径
     *
     * @param isPreview 是否是预览模式
     * @returns {string} 编译参数配置文件路径
     */
    getBuildConfigPath(isPreview?: boolean): string;
    getIntermediatesOutputMetadata(): string;
    getIntermediatesHspOutputMetadata(): string;
    getFromConfigPathByTargetName(moduleModel: CoreModuleModelImpl, targetName: string, formConfigName: string | undefined): string | undefined;
    getSyscapJsonPathInfo(moduleModel: ModuleModel): string;
    getPreviewIntermediatesResModuleJsonPath(): string;
    getPreviewIntermediatesMainPagesJsonPath(): string;
    getUnitTestTemplatePath(): string;
}
