export interface ModuleConfigTrace {
    MODULE_NAME: string;
    API_TYPE?: string;
    TARGETS?: Record<string, any>[];
    OBFUSCATION?: Record<string, any>;
    WORKERS?: string[];
    BUILD_PROFILE_FIELDS?: Record<string, any>;
    DEVICE_TYPES: string[];
    METADATA?: {
        NAME?: string;
        RESOURCE?: string;
    }[];
}
interface OhosTraceMessage {
    MODULE_CONFIG: ModuleConfigTrace[];
    ERROR_MESSAGE?: {
        TASK_TYPE: string;
        ERROR_CODE: string;
    };
}
declare class OhosTrace {
    private pluginName;
    private taskName;
    private readonly data;
    constructor();
    getData(): OhosTraceMessage;
    setTaskName(name: string): void;
    replaceModuleConfig(config: ModuleConfigTrace): void;
    traceToHvigor(isFailed?: boolean): void;
}
export declare const ohosTrace: OhosTrace;
export {};
