import { CompileModeEnum } from '../../enum/compile-mode-enum.js';
import { Named, Option, RequiredNamed } from '../options.js';
export declare namespace ModuleJson {
    interface SkillsObj {
        actions?: string[];
        entities?: string[];
    }
    interface AbilityObj extends RequiredNamed {
        srcEntrance?: string;
        srcEntry?: string;
        description?: string;
        icon?: string;
        label?: string;
        orientation?: string;
        visible?: boolean;
        skills?: SkillsObj[];
    }
    interface FormObj extends RequiredNamed {
        updateEnabled: boolean;
        scheduledUpdateTime?: number;
        updateDuration?: number;
        supportDimensions: string[];
        defaultDimension: string;
    }
    interface FormsObj extends Option {
        forms: FormObj[];
    }
    interface MetadataObj extends Named {
        resource?: string;
        value?: string;
    }
    interface UsedSceneObj extends Option {
        abilities?: string[];
        when?: string;
    }
    interface RequestPermissionObj extends RequiredNamed {
        reason?: string;
        usedScene?: UsedSceneObj;
    }
    interface DependencyObj {
        moduleName: string;
        bundleName?: string;
    }
    interface AtomicServiceObj {
        preloads: {
            moduleName: string;
        };
    }
    interface ExtensionAbilityObj extends RequiredNamed {
        srcEntrance?: string;
        srcEntry?: string;
        icon?: string;
        description?: string;
        type: string;
        visible?: boolean;
        metadata?: MetadataObj[];
    }
    interface ModuleObj extends RequiredNamed {
        type: string;
        srcEntrance?: string;
        srcEntry?: string;
        description?: string;
        mainElement?: string;
        deviceTypes: string[];
        deliveryWithInstall?: boolean;
        installationFree?: boolean;
        pages: string;
        abilities?: AbilityObj[];
        extensionAbilities?: ExtensionAbilityObj[];
        virtualMachine?: string;
        compileMode?: CompileModeEnum;
        metadata?: MetadataObj[];
        requestPermissions?: RequestPermissionObj[];
        dependencies?: DependencyObj[];
        libIsolation?: boolean;
        atomicService?: AtomicServiceObj;
        proxyData?: ProxyDataObj[];
    }
    interface ProxyDataObj {
        uri: string;
        requiredReadPermission: string;
        requiredWritePermission: string;
        metadata: MetadataObj;
    }
    interface ShortcutsObj {
        shortcutId: string;
        label: string;
        icon: string;
        wants: WantsObj[];
    }
    interface WantsObj {
        bundleName: string | undefined;
        abilityName: string;
    }
    interface ModuleOptObj {
        module: ModuleObj;
    }
}
