"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.BuildOptionCombiner=exports.BuildOptionUtil=void 0;const wdk_1=require("@baize/wdk"),build_mode_const_js_1=require("../../const/build-mode-const.js"),common_const_js_1=require("../../const/common-const.js"),ohos_logger_js_1=require("../../utils/log/ohos-logger.js"),log=ohos_logger_js_1.OhosLogger.getLogger("BuildOptionUtil");class BuildOptionUtil{static getDefaultModuleBuildOpt(e){var t;return null!==(t={debug:{debuggable:!0,copyFrom:"default"},release:{debuggable:!1,copyFrom:"default"},default:{debuggable:!0}}[e])&&void 0!==t?t:{}}static getDefaultBuildModeBuildOpt(e){var t;return null!==(t={debug:{debuggable:!0},release:{debuggable:!1},test:{debuggable:!0}}[e])&&void 0!==t?t:{}}static getOrDefaultBuildModeBinderSet(e){const t=this.arrayDeduplication(e,"buildModeName");t.forEach((e=>{e.mappings&&(e.mappings=this.arrayDeduplication(e.mappings,"targetName"))}));return[build_mode_const_js_1.BuildModeConst.DEBUG,build_mode_const_js_1.BuildModeConst.RELEASE,build_mode_const_js_1.BuildModeConst.TEST].forEach((o=>{e.some((e=>e.buildModeName===o))||t.push({buildModeName:o,mappings:[{targetName:common_const_js_1.DefaultTargetConst.DEFAULT_TARGET,buildOptionName:o===build_mode_const_js_1.BuildModeConst.RELEASE?build_mode_const_js_1.BuildOptionConst.RELEASE:build_mode_const_js_1.BuildOptionConst.DEBUG},{targetName:common_const_js_1.DefaultTargetConst.OHOS_TEST_TARGET,buildOptionName:build_mode_const_js_1.BuildOptionConst.DEFAULT}]})})),t}static arrayDeduplication(e,t="name"){const o=new Set,i=[];for(let n=e.length-1;n>=0;n--){const d=e[n];o.has(d[t])||(i.push(d),o.add(d[t]))}return i}static validateBuildMode(e,t){var o;(null!==(o=t.getProfileOpt().app.buildModeSet)&&void 0!==o?o:[]).map((e=>e.name)).concat([build_mode_const_js_1.BuildModeConst.DEBUG,build_mode_const_js_1.BuildModeConst.RELEASE,build_mode_const_js_1.BuildModeConst.TEST]).some((t=>t===e))||log._buildError(`Build mode '${e}' used in command line is not declared in buildModeSet in ${t.getProfilePath()}.`)._detail(`Use or add build mode '${e}' in 'buildModeSet' field of ${t.getProfilePath()}.`)._printErrorAndExit()}static validateBinderSet(e){var t,o;const i=e.getProfileOpt().buildModeBinder;if(void 0===i)return;const n=i.map((e=>e.buildModeName)),d=i.map((e=>{var t;return null!==(t=e.mappings)&&void 0!==t?t:[]})).flat(),l=d.map((e=>e.targetName)),r=d.map((e=>e.buildOptionName)),s=(null!==(t=e.getParentProject().getProfileOpt().app.buildModeSet)&&void 0!==t?t:[]).map((e=>e.name)).concat([build_mode_const_js_1.BuildModeConst.DEBUG,build_mode_const_js_1.BuildModeConst.RELEASE,build_mode_const_js_1.BuildModeConst.TEST]);this.validateBinderSetBuildModes(s,n,e);const a=e.getTargetOptions().map((e=>e.name)).concat([common_const_js_1.DefaultTargetConst.DEFAULT_TARGET]);this.validateBinderSetTargetNames(a,l,e);const u=(null!==(o=e.getProfileOpt().buildOptionSet)&&void 0!==o?o:[]).map((e=>e.name)).concat([build_mode_const_js_1.BuildOptionConst.DEFAULT,build_mode_const_js_1.BuildOptionConst.DEBUG,build_mode_const_js_1.BuildOptionConst.RELEASE]);this.validateBinderSetBuildOptNames(u,r,e)}static validateBuildOptionSet(e){const t=e.getProfileOpt().buildOptionSet;if(void 0===t)return;const o=t.map((e=>e.name));[build_mode_const_js_1.BuildOptionConst.DEFAULT,build_mode_const_js_1.BuildOptionConst.DEBUG,build_mode_const_js_1.BuildOptionConst.RELEASE].forEach((e=>{o.includes(e)||t.push({name:e})}));const i=this.buildOptionSetToMap(t);this.validateCopyFromNameExists(e,t,i),this.validateCopyFromCircle(e,t,i)}static isCopyFromNameExists(e,t){return e.copyFrom&&t.has(e.copyFrom)}static isCopyFromHasCircle(e,t,o){const i=new Set;let n=e;for(;n&&n.copyFrom;){if(null==o||o.push(n.name),i.has(n.name))return!0;i.add(n.name),n=t.get(n.copyFrom)}return!1}static buildOptionSetToMap(e){const t=new Map;return e.forEach((e=>{e.name&&t.set(e.name,e)})),t}static validateCopyFromNameExists(e,t,o){t.forEach((t=>{if(t.copyFrom){this.isCopyFromNameExists(t,o)||log.warn(`buildOptionSet config buildOption:${t.name} copyFrom name:${t.copyFrom} not exists in ${e.getProfilePath()} .`)}}))}static validateCopyFromCircle(e,t,o){t.forEach((t=>{if(t.copyFrom){const i=[];this.isCopyFromHasCircle(t,o,i)&&log.errorMessageExit(`buildOptionSet config buildOption:${t.name} copyFrom has circle ${i.join(" -> ")} in ${e.getProfilePath()} .`)}}))}static validateBinderSetBuildModes(e,t,o){t.forEach((t=>{e.includes(t)||log._buildError(`Build mode '${t}' used in buildModeBinder is not declared in buildModeSet in ${o.getParentProject().getProfilePath()}.`)._detail(`Use or add build mode '${t}' in 'buildModeSet' field of ${o.getParentProject().getProfilePath()}.`)._printErrorAndExit()}))}static validateBinderSetTargetNames(e,t,o){t.forEach((t=>{e.includes(t)||log._buildError(`Target '${t}' used in buildModeBinder is not declared in ${o.getProfilePath()}`)._detail(`Use or add target in 'targets' field of ${o.getProfilePath()}.`)._printErrorAndExit()}))}static validateBinderSetBuildOptNames(e,t,o){t.forEach((t=>{e.includes(t)||log._buildError(`Build option '${t}' used in buildModeBinder is not declared in ${o.getProfilePath()}`)._detail(`Use or add build option in 'buildOptionSet' field of ${o.getProfilePath()}.`)._printErrorAndExit()}))}}exports.BuildOptionUtil=BuildOptionUtil;class BuildOptionCombiner{static replaceBuildOption(e,t){if(e.name!==t.name)throw new Error("only buildOption with same name can be replaced");return replace(e,t)}static mergeBuildOption(e,t){return merge(e,t)}static processCopyFrom(e){const t=BuildOptionUtil.buildOptionSetToMap(e);for(let o=0;o<e.length;o++){const i=e[o];if(i.copyFrom&&!BuildOptionUtil.isCopyFromHasCircle(i,t)){const n=doCopyFromMerge(i,t);n&&(e[o]=n)}}}}function replace(e,t){return(0,wdk_1.cloneDeep)(t)}function merge(e,t){const o=new Set([...Object.keys(e),...Object.keys(t)]),i={};return o.forEach((o=>{const n=(0,wdk_1.cloneDeep)(e[o]),d=(0,wdk_1.cloneDeep)(t[o]);o in e&&o in t?isObject(n)&&isObject(d)?i[o]=merge(n,d):i[o]=d:o in e?i[o]=n:o in t&&(i[o]=d)})),i}function isObject(e){return null!==e&&"object"==typeof e&&!Array.isArray(e)}function doCopyFromMerge(e,t){const o=[];let i=e;for(;i&&i.name&&(o.push(i.name),i.copyFrom);)i=t.get(i.copyFrom);if(o.length<1)return;if(1===o.length)return e;const n=o.reverse();let d=t.get(n[0]);for(let e=1;e<n.length;e++){const o=t.get(n[e]);d&&o&&(d=BuildOptionCombiner.mergeBuildOption(d,o))}return d}exports.BuildOptionCombiner=BuildOptionCombiner;