export interface SdkInfo {
    isOhos: boolean;
    hasRollUpPluginInEtsLoader: boolean;
    hasRollUpPluginInJsLoader: boolean;
    setup(): void;
    getArkUIXSdkDir(): string;
    isPreviewCompileResourceIncrement(isHarmonyOS: boolean): any;
    supportOhpmProject(isHarmonyOS: boolean): any;
    /**
     * 检查当前版本sdk是否已经修复了卡片编译的问题
     * @returns {boolean}
     * @private
     */
    checkAotFixedSdkVersion(): boolean;
    /**
     * 获取当前sdk中对应api 的toolchains组件的小版本号
     *
     * @return {string | undefined}
     */
    getToolchainsComponentVersion(): string | undefined;
    getHosToolchainsComponentVersion(): string | undefined;
    getModuleSchema(): string;
    getAppSchema(): string;
    getInsightIntentSchema(): string;
    getFormSchema(): string;
    getPageSchema(): string;
    getSdkJsDir(): string;
    getSdkEtsDir(): string;
    getSdkVersion(): number;
    getSdkApi(): string;
    getHapTobin(): string;
    getReleaseType(): string;
    getSdkNativeDir(): string;
    getCmakeTool(): string;
    getNativeNinjaTool(): string;
    getNativeToolchain(): string;
    getSdkToolchainsDir(): string;
    getSdkLlvmStrip(): string;
    getRestool(): string;
    getSysCapTool(): string;
    getSysCapFileInEts(): string;
    getSysCapFileInJs(): string;
    getVerifySignConfigTool(): string;
    getRichSchema(): string;
    getLiteSchema(): string;
    getArkVersion(compatibleSdkVersion: number): string;
    getEtsComponentVersion(): string;
    getEtsComponentReleaseType(): string;
    getPackageTool(): string;
    getSignDir(): string;
    getJsLoader(): string;
    getEtsLoader(): string;
    requireUISyntax(): boolean;
    getHmsNativeDir(): string;
    getHmsToolchainFile(): string;
    getHmsArkDir(): string;
    getHosResTool(): string;
    getOhosJar(): string;
    getHapSignToolV2(): string;
    getHosModuleSchema(): string;
}
export declare enum SdkComponentType {
    ETS = "ets",
    JS = "js",
    PREVIEWER = "previewer",
    NATIVE = "native",
    TOOLCHAINS = "toolchains"
}
