import { FileSet, TaskDetails } from '@ohos/hvigor';
import { ModulePathInfoIml } from '../../common/iml/module-path-info-iml.js';
import { JsonProfile } from '../../model/json-profile.js';
import { TargetTaskService } from '../service/target-task-service.js';
import { OhosHapTask } from '../task/ohos-hap-task.js';
/**
 * Syscap Transform task
 *
 * @since 2022/09/8
 */
export declare abstract class AbstractSyscapTransform extends OhosHapTask {
    protected readonly sourceRoot: string;
    protected readonly pathInfo: ModulePathInfoIml;
    protected readonly syscapJsonPath: string;
    protected readonly rpcidScPath: string;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    protected constructor(taskService: TargetTaskService, taskName: TaskDetails);
    initTaskDepends(): void;
    protected doTaskAction(): Promise<void>;
    getSysCapPath(): string;
    protected abstract getJsonProfileByModel(): JsonProfile;
    /**
     * 根据Syscap.json中deviceType获取sdk提供的对应deviceType的Syscap全集
     *
     * @param requireSysCapPath sdk/(etsPath/jsPath)
     * @param deviceInSysCap    Syscap.json中deviceType
     * @param requireSysCapList 对应Syscap全集
     */
    protected getRequireSysCapList(requireSysCapPath: string, deviceInSysCap: string, requireSysCapList: Set<string>): void;
    /**
     * 求NDeviceType交集
     *
     * @param sysCapJson NDeviceType中SysCap
     * @param list  NDeviceType交集
     * @param regExp regExp
     * @param sysCapJsonPath sysCapJsonPath
     */
    protected intersectNDeviceSysCap(sysCapJson: any, list: string[][], regExp: RegExp, sysCapJsonPath: string): Set<string>;
    /**
     * 根据production配置做增删
     *
     * @param sysCapJson syscap.json
     * @param regExp syscap regExp
     * @param intersectionSysCapList syscap交集集合
     * @param field production配置(addedSysCaps/removedSysCaps)
     * @protected
     */
    protected addOrRemoveSyscapByProduction(sysCapJson: any, regExp: RegExp, intersectionSysCapList: Set<string>, field: string): void;
}
