import { FileSet, TaskDetails, TaskInputValue } from '@ohos/hvigor';
import { ObfuscationOptions, ProjectConfig } from '@ohos/hvigor-arkts-compose';
import { CodeType } from '../enum/code-type-enum.js';
import { OhosLogger } from '../utils/log/ohos-logger.js';
import { AbstractCompileNode } from './abstract/abstract-compile-node.js';
import { TargetTaskService } from './service/target-task-service.js';
export declare class ArkCompile extends AbstractCompileNode {
    protected _log: OhosLogger;
    protected readonly needSubmitArkTsWidget: boolean;
    private readonly formJsonPathArr;
    protected obfuscationOptions?: ObfuscationOptions;
    protected obfuscationHash?: string;
    constructor(taskService: TargetTaskService, codeType: CodeType, taskDetails: TaskDetails);
    taskShouldDo(): boolean;
    declareInputs(): Map<string, TaskInputValue>;
    beforeAlwaysAction(): Promise<void>;
    protected beforeTask(): Promise<void>;
    declareInputFiles(): FileSet;
    protected doTaskAction(): Promise<void>;
    protected initDefaultArkCompileConfig(): Promise<ProjectConfig>;
    private initWidgetDefaultArkCompileConfig;
    /**
     * Determine if project need compile arkTS widget.
     * To avoid arkTS project + js widget.
     *
     * @returns true | fasle
     */
    private shouldCompileArkTsWidget;
    initTaskDepends(): void;
    /**
     * 获取传递给etsLoader的ark混淆配置
     * API10以上stage模型release模式可用
     *
     * selfConfig
     * dependencies
     * sdkApis
     * obfuscationCacheDir
     * exportRulePath
     *
     * @return ObfuscationOptions
     * @return undefined
     */
    getObfuscationOptions(): Promise<ObfuscationOptions | undefined>;
    computeObfuscationFileHash(obfuscationOptions: ObfuscationOptions): string;
    protected getIncrementalCacheItem(key: string): TaskInputValue | undefined;
    /**
     * 清除arkts代码缓存目录build/${product}/cache/${target}/default@CompileArkTS/esmodule/${buildMode}
     *
     * @protected
     */
    protected cleanCache(): Promise<void>;
    protected validateMockFilePath(): void;
}
