import { FileSet, TaskDetails, TaskInputValue } from '@ohos/hvigor';
import { OhosLogger } from '../../utils/log/ohos-logger.js';
import { TargetTaskService } from '../service/target-task-service.js';
import { OhosHapTask } from '../task/ohos-hap-task.js';
/**
 * Stage模型打包Hap包的基类
 *
 * @since 2023/1/17
 */
export declare abstract class BasePackHapTask extends OhosHapTask {
    protected readonly mode: string;
    protected readonly libPath: string;
    protected readonly jsonPath: string;
    protected readonly resourcePath: string;
    protected readonly indexPath: string;
    protected readonly rpcidSc: string;
    protected readonly jsAssetsPath: string;
    protected readonly etsAssetsPath: string;
    protected readonly nodeModulesPath: string;
    protected readonly allPackInfoPath: string[];
    protected readonly allOutPath: string[];
    protected syscapJsonPath: string;
    private readonly anBuildOutputPath;
    private readonly apDirPath;
    private moduleBuildOpt;
    private readonly buildOption?;
    readonly _log: OhosLogger;
    declareExecutionTool(): string;
    declareExecutionCommand(): string;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    protected constructor(taskService: TargetTaskService, detail: TaskDetails, mode: string, logger: OhosLogger);
    declareInputs(): Map<string, TaskInputValue>;
    protected doTaskAction(): Promise<void>;
    private executeCommandList;
    /**
     * 生成命令
     *
     * @param packInfoPath pack.info路径
     * @param outPath 输出路径
     * @returns 命令
     */
    private generateCommand;
    private getSuffix;
    initTaskDepends(): void;
}
export declare const packageHapDepends: (service: TargetTaskService) => string[];
