import { FileSet } from '@ohos/hvigor';
import { DebugSymbol } from '../options/build/build-opt.js';
import { AbstractNativeStrip } from './abstract/abstract-native-strip.js';
import { TargetTaskService } from './service/target-task-service.js';
export declare class DoNativeStrip extends AbstractNativeStrip {
    private _log;
    constructor(targetService: TargetTaskService);
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    protected doTaskAction(): Promise<void>;
    initTaskDepends(): void;
    taskShouldDo(): boolean;
}
export declare class StripWorker {
    /**
     * 用来向线程池提交的任务入口
     * @private
     */
    static doStrip(stripOptions: StripOptions): Promise<void>;
    static readCache(stripOptions: StripOptions): Promise<any>;
    /**
     * 根据缓存判断是否需要strip
     * @param stripOptions
     * @param filePath
     * @param lastCache
     * @private
     */
    private static needStripCache;
    /**
     * 清除掉上次编译但本次已经在libs文件夹下没有了的.so文件
     * @param processStrippedLibsDir
     * @param processLibsDir
     */
    static cleanStrippedSo(processStrippedLibsDir: string, processLibsDir: string): void;
    private static copySoFile;
    private static executeStrip;
}
interface StripOptions {
    debugSymbol: DebugSymbol | undefined;
    strip: boolean;
    exclude: string[];
    intermediatesProcessLibs: string;
    sdkLlvmStripPath: string;
    outputDir: string;
    moduleName: string;
    taskName: string;
    cacheFilePath: string;
    lastCache: string;
}
export {};
