import { TargetTaskService } from '../service/target-task-service.js';
import { OhPackageJsonOpt } from '../task/ohos-har-task.js';
import { CoreProcessPackageJson } from './core-process-package-json.js';
/**
 * 闭源Har打包发布前需要对package.json文件进行处理和增加一些信息
 * 当前该任务执行处理很快,先不需要做增量
 */
export declare class ProcessOhPackageJson extends CoreProcessPackageJson {
    private readonly generateOhPackageJsonFilePath;
    private readonly workerConfig;
    constructor(taskService: TargetTaskService);
    protected doTaskAction(): void;
    protected addArtifactType(packageJsonObj: OhPackageJsonOpt): void;
    /**
     * 向oh-package.json5里添加worker信息
     *
     * @protected
     */
    protected addWorkerData(): void;
    /**
     * 处理worker信息
     *
     * @returns {string[] | undefined}
     * @private
     */
    private processWorkerConfig;
    /**
     * 构建har包时需要将dynamicImport写入har产物oh-package.json5的metadata中
     * 闭源har模块需要保证以相对路径形式导入的文件后缀为js格式写入
     * 包名,文件名,文件夹相对路径保持不变写入
     * @protected
     */
    protected addDynamicImport(): void;
}
