import { FileSet } from '@ohos/hvigor';
import { TargetTaskService } from '../service/target-task-service.js';
import { OhosHapTask } from '../task/ohos-hap-task.js';
/**
 * 生成打包shared library的package.json和module.json
 *
 * @since 2023/1/18
 */
export declare class PrepareSharedHarRes extends OhosHapTask {
    private readonly inputPackageJson5Path;
    private readonly inputModuleJsonPath;
    private readonly inputDeclareFilesPath;
    private readonly headerPath?;
    private readonly libsPath;
    private readonly taskTmpDir;
    private readonly outputPackageJsonPath;
    private readonly outputModuleJsonPath;
    private readonly outputDeclareFilesPath;
    private readonly INTERFACE_HAR;
    private readonly _moduleDir;
    private readonly ignoreFileList;
    private readonly allInvalidPrefix;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    constructor(taskService: TargetTaskService);
    initTaskDepends(): void;
    protected doTaskAction(): Promise<void>;
    private syncNative;
    /**
     * 根据hsp模块的package.json，用main字段信息替换types字段，并删除main字段
     *
     * @private
     */
    private generatePackageJson;
    private copyLocalDepsFileToTempDir;
    /**
     * 根据hsp模块的module.json，筛选指定字段作为har包的module.json的字段
     *
     * @private
     */
    private generateModuleJson;
    /**
     * 根据package.json的main字段，拼接出对应的types字段字符串
     *
     * @param {string | undefined} main main字段的值
     * @returns {string} types字段的值
     * @private
     */
    private getTypesFieldFromMainField;
    private preCheckBeforePack;
    private initAllInvalidPrefix;
}
