import { TargetTaskService } from './service/target-task-service.js';
import { OhosHapTask } from './task/ohos-hap-task.js';
export declare class PrepareQuickfix extends OhosHapTask {
    private readonly libsDir;
    private readonly debugSymbol?;
    private readonly libsCachePath;
    private readonly lastCachePath;
    constructor(taskService: TargetTaskService);
    protected doTaskAction(): Promise<void>;
    collectNativeLibs(): Promise<void>;
    private logQuickfixChanges;
    compareLibs(base: Record<string, string>, last: Record<string, string>, current: Record<string, string>): Record<string, number>;
    generatePatchJson(): Promise<void>;
    initTaskDepends(): void;
    static getCurrentHqfVersion(): Promise<number>;
}
export interface PatchJson {
    app: PatchApp;
    module: PatchModule;
}
export interface PatchApp {
    bundleName: string;
    versionCode: number;
    versionName: string;
    patchVersionCode: number;
    patchVersionName: string;
}
export interface PatchModule {
    name: string;
    type: string;
    deviceTypes: string[];
    originalModuleHash: string;
}
export interface Quickfix {
    changes: Record<string, number>;
    state: number;
    file: string;
}
