"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.PrepareQuickfix=void 0;const wdk_1=require("@baize/wdk"),hvigor_1=require("@ohos/hvigor"),promises_1=__importDefault(require("fs/promises")),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),file_util_js_1=require("../utils/file-util.js"),libs_file_cache_util_js_1=require("../utils/libs-file-cache-util.js"),ohos_logger_js_1=require("../utils/log/ohos-logger.js"),task_names_js_1=require("./common/task-names.js"),ohos_hap_task_js_1=require("./task/ohos-hap-task.js"),logger=ohos_logger_js_1.OhosLogger.getLogger("PrepareQuickfix");class PrepareQuickfix extends ohos_hap_task_js_1.OhosHapTask{constructor(e){super(e,task_names_js_1.TaskNames.Task.PREPARE_QUICKFIX),this.debugSymbol=this.targetService.getNativeLibOption().debugSymbol,this.libsDir=this.pathInfo.getIntermediatesStrippedLibsDir(),this.libsCachePath=path_1.default.resolve(this.pathInfo.getPatchDir(),"base_native_libs.json"),this.lastCachePath=path_1.default.resolve(this.pathInfo.getPatchDir(),"libs.json")}async doTaskAction(){await fs_extra_1.default.emptydir(path_1.default.resolve(this.pathInfo.getPatchDir(),"libs")),await this.collectNativeLibs(),file_util_js_1.FileUtil.checkDirWithoutDelete(path_1.default.resolve(this.pathInfo.getPatchDir(),"ets")),await libs_file_cache_util_js_1.LibsFileCacheUtil.refreshLibsFileCache(this.pathInfo.getIntermediatesProcessLibs(),this.libsDir,this.lastCachePath,this.debugSymbol),await this.generatePatchJson()}async collectNativeLibs(){const e=path_1.default.resolve(this.pathInfo.getPatchDir(),"libs");await fs_extra_1.default.emptydir(e);const t=fs_extra_1.default.existsSync(this.libsCachePath)?hvigor_1.Json5Reader.getJson5Obj(this.libsCachePath):{stripped:{},libs:{}},s=fs_extra_1.default.existsSync(this.lastCachePath)?hvigor_1.Json5Reader.getJson5Obj(this.lastCachePath):{stripped:{},libs:{}},i=fs_extra_1.default.existsSync(this.libsDir)?await libs_file_cache_util_js_1.LibsFileCacheUtil.generateFileHashesForDirectory(this.libsDir):{},a=this.compareLibs(t.stripped,s.stripped,i);await fs_extra_1.default.emptydir(e);await fs_extra_1.default.copy(this.libsDir,e,{filter:e=>fs_extra_1.default.statSync(e).isDirectory()||Object.entries(a).some((([t,s])=>""===path_1.default.relative(e,t)&&s>0)),recursive:!0,overwrite:!0}),await this.logQuickfixChanges(a)}async logQuickfixChanges(e){var t;await fs_extra_1.default.ensureDir(this.pathInfo.getModuleBuildOutputPath()),await fs_extra_1.default.writeJSON(path_1.default.resolve(this.pathInfo.getModuleBuildOutputPath(),"quickfix.json"),{changes:e,state:null!==(t=(0,wdk_1.max)(Object.values(e)))&&void 0!==t?t:0,file:`${this.moduleName}-${this.targetName}-unsigned.hqf`})}compareLibs(e,t,s){const i={};return Object.entries(s).forEach((([s,a])=>i[s]=t[s]&&t[s]!==a?2:e[s]&&e[s]===a?0:t[s]?1:2)),i}async generatePatchJson(){const e=await PrepareQuickfix.getCurrentHqfVersion(),t=this.projectModel.getAppRes().getAppResOpt(),s={app:{bundleName:t.app.bundleName,versionCode:t.app.versionCode,versionName:t.app.versionName,patchVersionCode:e,patchVersionName:String(e)},module:{name:this.moduleName,type:"patch",deviceTypes:this.moduleModel.getDeviceTypes(),originalModuleHash:""}};await promises_1.default.writeFile(path_1.default.resolve(this.pathInfo.getPatchDir(),"patch.json"),JSON.stringify(s)),logger.debug(`Prepare ${t.app.bundleName} quickfix with patch versionCode ${e}.`)}initTaskDepends(){this.declareDepends(task_names_js_1.TaskNames.Task.DO_NATIVE_STRIP.name)}static async getCurrentHqfVersion(){const e=path_1.default.resolve(hvigor_1.PathUtil.getHvigorCacheDir(logger),"outputs","patch","patch.json");if(!fs_extra_1.default.existsSync(e))return 3e6;const t=await fs_extra_1.default.readJSON(e);return parseInt((null==t?void 0:t.patchVersionCode)?t.patchVersionCode:3e6)}}exports.PrepareQuickfix=PrepareQuickfix;