import { HvigorCoreNode } from '@ohos/hvigor';
import { ProjectModel } from '../../model/project/project-model.js';
import { Dependency } from '../../project/dependency/core/dependency-interface.js';
import { ModuleDependencyInfo } from '../../project/dependency/module-dependency-info.js';
/**
 * 任务流服务的基础类
 *
 * @since 2022/1/20
 */
export declare class TaskService {
    protected hvigorNode: HvigorCoreNode;
    protected readonly _projectModel: ProjectModel;
    protected _moduleDependencyInfo: ModuleDependencyInfo;
    protected _isFaMode: boolean;
    constructor(node: HvigorCoreNode, projectModel: ProjectModel, moduleDependencyInfo: ModuleDependencyInfo, isFaMode: boolean);
    isFaMode(): boolean;
    getNode(): HvigorCoreNode;
    getProjectModel(): ProjectModel;
    /**
     * 获取所有依赖的main对应文件的路径的集合
     * @returns {string[]}
     */
    getDependencyMainPaths(): string[];
    /**
     * 获取所有依赖在node_modules中路径的集合
     * @returns {string[]}
     */
    getDependencyRootPaths(): string[];
    /**
     * 获取所有har依赖
     * @returns {Dependency[]}
     */
    getHarDependencies(): Dependency[];
    /**
     * 获取所有hsp依赖
     * @returns {Dependency[]}
     */
    getHspDependencies(): Dependency[];
    /**
     * 获取所有hsp依赖的路径的集合
     * @returns {Dependency[]}
     */
    getHspDependencyPaths(): string[];
    /**
     * 获取所有本地鸿蒙依赖模块
     * @returns {Dependency[]}
     */
    getModuleDependencies(): Dependency[];
    /**
     * 获取所有本地鸿蒙依赖模块的路径的集合
     * @returns {Dependency[]}
     */
    getModuleDependenciesPaths(): string[];
    /**
     * 获取所有本地依赖har模块
     * @returns {[string, Dependency][]}
     */
    getHarModuleDependencies(): [string, Dependency][];
    /**
     * 获取所有本地依赖har模块的名称
     * @returns {string[]}
     */
    getHarModuleDependencyNames(): string[];
    /**
     * 获取所有本地依赖har模块的路径
     * @returns {string[]}
     */
    getHarModuleDependencyPaths(): string[];
    /**
     * 获取所有本地依赖hsp模块
     * @returns {[string, Dependency][]}
     */
    getHspModuleDependencies(): [string, Dependency][];
    /**
     * 获取所有本地hsp依赖模块的名称
     * @returns {string[]}
     */
    getHspModuleDependencyNames(): string[];
    /**
     * 获取所有本地hsp依赖模块的路径
     * @returns {string[]}
     */
    getHspModuleDependencyPaths(): string[];
    /**
     * 获取除Dynamic所有本地hsp依赖模块的路径
     * @returns {string[]}
     */
    getHspModuleDependencyPathsWithOutDynamic(): string[];
    /**
     * 判断本模块是否有hsp依赖
     * @returns {[string, Dependency][]}
     */
    hasHspDependencies(): boolean;
    getDependencyInfo(): ModuleDependencyInfo;
}
