import { TaskDetails } from '@ohos/hvigor';
import { SignTypeEnum } from '../enum/sign-type-enum.js';
import { ProjectBuildProfile } from '../options/build/project-build-profile.js';
import { BaseSign } from './base/base-sign.js';
import { TargetTaskService } from './service/target-task-service.js';
import { SignModel } from './sign/command-builder-impl/sign-model.js';
import RemoteHspOpt = ProjectBuildProfile.RemoteHspOpt;
export declare abstract class SignRemoteHsp extends BaseSign {
    protected readonly allProjectSignedRemoteHspList: SignModel[];
    protected readonly allModuleSignedRemoteHspList: SignModel[];
    protected readonly allProjectRequiredSignRemoteHspMap: Map<string, RemoteHspOpt>;
    protected readonly allModuleRequiredSignRemoteHspMap: Map<string, RemoteHspOpt>;
    protected readonly allProjectHspPathList: string[];
    protected readonly allModuleHspPathList: string[];
    protected readonly allProjectRemoteHspPathList: string[];
    protected readonly allModuleRemoteHspPathList: string[];
    protected readonly allProjectHspToModuleHspList: string[];
    protected readonly allModuleHspNeedProjectHspList: string[];
    protected constructor(targetService: TargetTaskService, taskDetails: TaskDetails, signType?: SignTypeEnum);
    protected doTaskAction(): Promise<void>;
    /**
     * 获取工程级需要签名的remoteHspMap
     * @param remoteHspPath
     * @protected
     */
    protected getProjectSignRemoteHspMap(remoteHspPath: string): void;
    /**
     * 获取模块级级需要签名的remoteHspMap
     * @param remoteHspPath
     * @protected
     */
    protected getModuleSignRemoteHspMap(remoteHspPath: string): void;
    /**
     * 初始化工程级需要签名的remoteHspList
     * @private
     */
    protected initAllProjectSignRemoteHspList(): void;
    /**
     * 初始化模块级需要签名的remoteHspList
     * @private
     */
    protected initAllModuleSignRemoteHspList(): void;
    /**
     * 拷贝模块级别oh_modules下.hsp目录中的hsp文件到当前模块的remote_hsp路径
     * @private
     */
    protected copyHspFileToModule(remoteHspDir: string): Promise<void>;
    /**
     * 拷贝工程级别oh_modules下.hsp目录中的hsp文件到当前工程的remote_hsp路径
     * @private
     */
    protected copyHspFileToProject(remoteHspDir: string): Promise<void>;
    /**
     * 工程级已签名的remoteHsp文件需要拷贝到模块级remote-hsp目录的list，
     * @protected
     */
    protected initProjectHspFileToModule(): void;
    /**
     * 拷贝工程模块签好名的hsp文件到对应模块的remote_hsp目录下
     * @protected
     */
    protected copyProjectHspFileToModule(): Promise<void>;
    /**
     * 删除当前模块/工程目录下的remote_hsp文件夹
     * @private
     */
    protected deleteRemoteHspDir(remoteHspDir: string): Promise<void>;
    initTaskDepends(): void;
}
