/**
 * 处理文件的工具类
 *
 * @since 2021/12/29
 */
export declare class FileUtil {
    private static _log;
    static isDirectory(...pathSegments: string[]): boolean;
    static checkDirWithoutDelete(...pathSegments: string[]): void;
    static checkFile(...pathSegments: string[]): void;
    static makeFile(filePath: string, data?: string): void;
    static deleteFile(filePath: string): void;
    static readFile(filePath: string): string | undefined;
    /**
     * 校验路径长度
     *
     * @param path 待校验的路径
     */
    static checkPathLength(path: string): void;
    static hashEntry(dir: string, test?: RegExp): Promise<Map<string, string>>;
    private static readDir;
    private static pipelineAsync;
    /**
     * 将路径转换为绝对路径
     *
     * @param {string} dir 文件或目录路径
     * @param {string} currentDir 当前路径，参考路径
     * @return {string} 转换后的绝对路径
     */
    static convertToAbsolutePath(dir: string, currentDir: string): string;
    static convertToAbsolutePaths(dirs: string[], currentDir: string): string[];
    static isSubDir(parent: string, child: string): boolean | "";
    /**
     * 校验文件是否存在
     *
     * @param completePath 文件完整路径
     */
    static fileExists(completePath: string): boolean;
    static copySpecialFileToTempDir(_moduleDir: string, taskTmpDir: string): void;
    static checkSpecialFile(fileName: string): boolean;
    /**
     * 重复文件名处理
     * @param fileNames  工程目录结构中读取的文件名数组
     * @param profileName 新增文件名
     * @private
     */
    static uniqueFileName(fileNames: string[], profileName: string): string | undefined;
    /**
     * 给重复文件添加后缀以区分唯一文件名
     * @param name
     * @param index
     */
    static addSuffix(name: string, index: number): string;
    /**
     * 遍历文件夹获取其中所有文件的文件名
     * @param fileFolderPath
     */
    static traverseFileFolder(fileFolderPath: string): string[];
    /**
     * 遍历文件夹并获取其中所有的文件路径
     * @param fileFolderPath
     */
    static getAllFilesFromFolder(fileFolderPath: string): string[];
    /**
     * 获取文件格式后缀
     * @param filePath
     */
    static getFileSuffix(filePath: string): string;
    /**
     * 读取路径时将分隔符转为正斜杆
     * eg: a\\b\\c -> a/b/c
     *
     * @param {string} path 原始字符串
     * @returns {string} 转化后的字符串
     */
    static normalizePathSeparator(path: string): string;
}
