"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var isSymbol_1 = __importDefault(require("../isSymbol"));
var NAN_VALUE = 6;
var typeValueMap = (_a = {},
    _a[typeof true] = 0,
    _a[typeof 1] = 1,
    _a[typeof 'a'] = 2,
    _a[typeof Symbol('a')] = 3,
    _a[typeof null] = 4,
    _a[typeof undefined] = 5,
    _a);
/**
 * 默认两个值的比较，详细参看<https://open.codehub.huawei.com/OpenBaize/JS/wdk/issues/13>
 * @param value 需要比较的值
 * @param another 另外一个比较的值
 * @returns 返回value和another的比较结果，如果value大于another，则返回1，相等返回0，小于则返回-1.
 */
function ascComparator(value, another) {
    var vType = typeof value;
    var anothType = typeof another;
    var vIsNaN = Number.isNaN(value);
    var anothIsNaN = Number.isNaN(another);
    var comparable1;
    var comparable2;
    if (vType === anothType && !vIsNaN && !anothIsNaN) {
        comparable1 = value;
        comparable2 = another;
        // Symbol 比较的时候，按照 description 字符串进行计较
        if ((0, isSymbol_1.default)(value)) {
            comparable1 = value.description;
            comparable2 = another.description;
        }
    }
    else {
        comparable1 = vIsNaN ? NAN_VALUE : typeValueMap[vType];
        comparable2 = anothIsNaN ? NAN_VALUE : typeValueMap[anothType];
    }
    return compare(comparable1, comparable2);
}
exports.default = ascComparator;
function compare(comparable1, comparable2) {
    if (comparable1 > comparable2) {
        return 1;
    }
    else if (comparable1 < comparable2) {
        return -1;
    }
    else {
        return 0;
    }
}
