"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyObject = void 0;
var assignUtil_1 = require("./assignUtil");
var validCheck_1 = require("./validCheck");
function copyObject(source, props, object, customizer) {
    var e_1, _a;
    var obj = object;
    var isNew = !obj;
    if (!(0, validCheck_1.isObject)(obj)) {
        obj = {};
    }
    try {
        for (var props_1 = __values(props), props_1_1 = props_1.next(); !props_1_1.done; props_1_1 = props_1.next()) {
            var key = props_1_1.value;
            var newValue = customizer
                ? customizer(obj[key], source[key], key, obj, source)
                : undefined;
            if (newValue === undefined) {
                newValue = source[key];
            }
            if (isNew) {
                (0, assignUtil_1.baseAssignValue)(obj, key, newValue);
            }
            else {
                (0, assignUtil_1.assignValue)(obj, key, newValue);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (props_1_1 && !props_1_1.done && (_a = props_1.return)) _a.call(props_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return obj;
}
exports.copyObject = copyObject;
