"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 判断 value 是否是一个数字。
 * NaN 表示非数字，它是一个无法表示的数据，因此不能与任何值进行比较，甚至是自己都不行。
 * @param value 被检查的值
 * @returns (boolean) 返回 true 如果指定的 value 不是一个数字，否则返回 false
 * @example
 * _.isNaN(NaN);
 * // => true
 *
 * _.isNaN(new Number(NaN));
 * // => true
 *
 * isNaN(undefined);
 * // => true
 *
 * _.isNaN(undefined);
 * // => false
 */
function isNaN(value) {
    if (value === void 0) { value = undefined; }
    var realValue = value;
    if (value instanceof Object) {
        realValue = value.valueOf();
    }
    // eslint-disable-next-line no-self-compare
    return realValue !== realValue;
}
exports.default = isNaN;
