"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 将数组array的元素通过iteratee进行值映射，计算映射后的值的平均值
 * @param array，待处理的数组
 * @param iteratee，用于对数组元素的值进行映射（转换）
 * @return 一个平均值，或者NaN（如果计算结果非number）
 */
function meanBy(array, iteratee) {
    if (!(array === null || array === void 0 ? void 0 : array.length)) {
        return NaN;
    }
    var computedArr = array.map(function (el) { return (typeof iteratee === 'function' ? iteratee(el) : el[iteratee]); });
    var sum = computedArr.reduce(function (pre, cur) { return pre + cur; });
    return sum / array.length;
}
exports.default = meanBy;
