"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.baseMerge = void 0;
var assign_1 = require("./assign");
var assignUtil_1 = require("./common/assignUtil");
var baseClone_1 = require("./common/baseClone");
var cloneBuffer_1 = __importDefault(require("./common/cloneBuffer"));
var copyArray_1 = __importDefault(require("./common/copyArray"));
var toPlainObject_1 = __importDefault(require("./common/toPlainObject"));
var Stack_1 = require("./common/Stack");
var validCheck_1 = require("./common/validCheck");
var eq_1 = __importDefault(require("./eq"));
var isArrayLikeObject_1 = __importDefault(require("./isArrayLikeObject"));
var isFunction_1 = __importDefault(require("./isFunction"));
var isObject_1 = __importDefault(require("./isObject"));
var isPlainObject_1 = __importDefault(require("./isPlainObject"));
var isTypedArray_1 = __importDefault(require("./isTypedArray"));
var keysIn_1 = __importDefault(require("./keysIn"));
function safeGet(object, key) {
    if (key === 'constructor' && typeof object[key] === 'function') {
        return undefined;
    }
    if (key === '__proto__') {
        return undefined;
    }
    return object[key];
}
function assignMergeValue(object, key, value) {
    if ((value !== undefined && !(0, eq_1.default)(object[key], value))
        || (value === undefined && !(key in object))) {
        (0, assignUtil_1.baseAssignValue)(object, key, value);
    }
}
function getNewValue(srcValue, objValue) {
    var isCommon = true;
    var newValue = srcValue;
    var isArr = Array.isArray(srcValue);
    var isBuff = !isArr && Buffer.isBuffer(srcValue);
    var isTyped = !isArr && !isBuff && (0, isTypedArray_1.default)(srcValue);
    if (isArr || isBuff || isTyped) {
        if (Array.isArray(objValue)) {
            newValue = objValue;
        }
        else if ((0, isArrayLikeObject_1.default)(objValue)) {
            newValue = (0, copyArray_1.default)(objValue, undefined);
        }
        else if (isBuff) {
            isCommon = false;
            newValue = (0, cloneBuffer_1.default)(srcValue, true);
        }
        else if (isTyped) {
            isCommon = false;
            newValue = (0, baseClone_1.cloneTypedArray)(srcValue, true);
        }
        else {
            newValue = [];
        }
    }
    else if ((0, isPlainObject_1.default)(srcValue) || (0, validCheck_1.isArguments)(srcValue)) {
        newValue = objValue;
        if ((0, validCheck_1.isArguments)(objValue)) {
            newValue = (0, toPlainObject_1.default)(objValue);
        }
        else if (!(0, isObject_1.default)(objValue) || (0, isFunction_1.default)(objValue)) {
            newValue = (0, baseClone_1.initCloneObject)(srcValue);
        }
    }
    else {
        isCommon = false;
    }
    return { newValue: newValue, isCommon: isCommon };
}
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = safeGet(object, key);
    var srcValue = safeGet(source, key);
    var stacked = stack.get(srcValue);
    if (stacked) {
        assignMergeValue(object, key, stacked);
        return;
    }
    var newValue = customizer
        ? customizer(objValue, srcValue, ("".concat(key)), object, source, stack)
        : undefined;
    var isCommon = newValue === undefined;
    if (isCommon) {
        var ret = getNewValue(srcValue, objValue);
        newValue = ret.newValue;
        isCommon = ret.isCommon;
    }
    if (isCommon) {
        // Recursively merge objects and arrays (susceptible to call stack limits).
        stack.set(srcValue, newValue);
        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
        stack.delete(srcValue);
    }
    assignMergeValue(object, key, newValue);
}
var baseMerge = function (object, source, srcIndex, customizer, _stack) {
    if (object === source) {
        return;
    }
    var stack = _stack || new Stack_1.Stack(undefined);
    var keys = (0, keysIn_1.default)(source);
    keys.forEach(function (key) {
        var srcValue = source[key];
        if ((0, isObject_1.default)(srcValue)) {
            baseMergeDeep(object, source, key, srcIndex, exports.baseMerge, customizer, stack);
        }
        else {
            var newValue = customizer
                ? customizer(safeGet(object, key), srcValue, ("".concat(key)), object, source, stack)
                : undefined;
            if (newValue === undefined) {
                newValue = srcValue;
            }
            assignMergeValue(object, key, newValue);
        }
    });
};
exports.baseMerge = baseMerge;
/**
 * 该方法类似assign， 除了它递归合并 sources 来源对象自身和继承的可枚举属性到 object 目标对象。
 * 如果目标值存在，被解析为undefined的sources 来源对象属性将被跳过。
 * 数组和普通对象会递归合并，其他对象和值会被直接分配覆盖。源对象从从左到右分配。
 * 后续的来源对象属性会覆盖之前分配的属性。
 *
 * 注意：这方法会改变对象 object.
 *
 * @param {Object} object 目标对象。
 * @param {...Object} [sources] 来源对象。
 * @returns {Object} Returns `object`.
 */
var merge = (0, assign_1.createAssignFunction)(function (object, source, srcIndex) {
    return (0, exports.baseMerge)(object, source, srcIndex);
});
exports.default = merge;
