/**
 * 和 merge 方法类似，但是额外提供一个 customizer 方法，
 * 该方法会决定如何对源对象和目标对象的值进行 merge
 *
 * @note 该方法会修改目标对象
 * @param {Object} object 目标对象
 * @param {...Object} sources 源对象
 * @param {Function} customizer 自定义对象merge方法.
 * @returns {Object} mergeWith 后的对象
 * @example
 *
 * function customizer(objValue, srcValue) {
 *   if (Array.isArray(objValue)) {
 *     return objValue.concat(srcValue)
 *   }
 * }
 *
 * const object = { 'a': [1], 'b': [2] }
 * const other = { 'a': [3], 'b': [4] }
 *
 * mergeWith(object, other, customizer)
 * // => { 'a': [1, 3], 'b': [2, 4] }
 */
declare const mergeWith: (object: any, ...sources: any[]) => any;
export default mergeWith;
