"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var pick_1 = require("./pick");
function checkKeyExist(key, filters) {
    var e_1, _a;
    var exist = false;
    try {
        for (var filters_1 = __values(filters), filters_1_1 = filters_1.next(); !filters_1_1.done; filters_1_1 = filters_1.next()) {
            var eachFilter = filters_1_1.value;
            if (key === eachFilter) {
                exist = true;
                break;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (filters_1_1 && !filters_1_1.done && (_a = filters_1.return)) _a.call(filters_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return exist;
}
function getNestedRest(input, preKey, filters, result) {
    var newObj = {};
    (0, pick_1.getObjectKeys)(input).forEach(function (eachKey) {
        var realKey = "".concat(preKey, ".").concat(eachKey);
        if (!checkKeyExist(realKey, filters) && Object.getOwnPropertyDescriptor(input, eachKey).enumerable) {
            var valueIsObject = Object.prototype.toString.call(input[eachKey]) === '[object Object]';
            if (!valueIsObject) {
                newObj[eachKey] = input[eachKey];
            }
            else {
                var res = getNestedRest(input[eachKey], realKey, filters, result);
                if (JSON.stringify(res) !== '{}') {
                    newObj[eachKey] = res;
                }
            }
        }
    });
    return newObj;
}
function setPropsToResult(input, filters, result) {
    (0, pick_1.getObjectKeys)(input).forEach(function (eachKey) {
        if (!checkKeyExist(eachKey, filters) && Object.getOwnPropertyDescriptor(input, eachKey).enumerable) {
            var valueIsObject = Object.prototype.toString.call(input[eachKey]) === '[object Object]';
            if (!valueIsObject) {
                result[eachKey] = input[eachKey];
            }
            else {
                var res = getNestedRest(input[eachKey], eachKey, filters, result);
                if (JSON.stringify(res) !== '{}') {
                    result[eachKey] = res;
                }
            }
        }
    });
}
/**
 * 处理普通对象、及其原型对象
 * @param input
 * @param ignoreList
 */
function processCommonObject(input, ignoreList) {
    var result = {};
    setPropsToResult(input, ignoreList, result);
    // input的原型对象
    var protoTypeOfObj = Object.getPrototypeOf(input);
    if (Array.isArray(protoTypeOfObj)) {
        return result;
    }
    setPropsToResult(protoTypeOfObj, ignoreList, result);
    return result;
}
/**
 * 处理有嵌套属性的对象、及其原型对象
 * @param input
 * @param filterList
 */
function processNestedObject(input, ignoreList) {
    var result = {};
    setPropsToResult(input, ignoreList, result);
    // input的原型对象
    var protoTypeOfObj = Object.getPrototypeOf(input);
    setPropsToResult(protoTypeOfObj, ignoreList, result);
    return result;
}
/**
 * 创建一个从 object 中忽略的属性的对象，返回忽略属性后的新对象
 * 反向版pick。这个对象由忽略属性之外的object自身和继承的可枚举属性组成。（注：可以理解为删除object对象的属性）。
 * @param input 来源对象
 * @param ignoreProps 保留的属性
 */
function omit(input) {
    var ignoreProps = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        ignoreProps[_i - 1] = arguments[_i];
    }
    if (input === null || input === undefined) {
        return {};
    }
    var ignoreList = (0, pick_1.getFilters)(ignoreProps);
    if (!(0, pick_1.checkIsNestedObject)(input)) {
        return processCommonObject(input, ignoreList);
    }
    return processNestedObject(input, ignoreList);
}
exports.default = omit;
