"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkIsNestedObject = exports.getNestedValue = exports.getObjectKeys = exports.getFilters = void 0;
var pull_1 = __importDefault(require("./pull"));
var isNumber_1 = __importDefault(require("./isNumber"));
var toString_1 = __importDefault(require("./toString"));
var validCheck_1 = require("./common/validCheck");
var isSymbol_1 = __importDefault(require("./isSymbol"));
var concat_1 = __importDefault(require("./concat"));
var isString_1 = __importDefault(require("./isString"));
function getFilters(savedProps) {
    var e_1, _a;
    var result = [];
    try {
        for (var savedProps_1 = __values(savedProps), savedProps_1_1 = savedProps_1.next(); !savedProps_1_1.done; savedProps_1_1 = savedProps_1.next()) {
            var item = savedProps_1_1.value;
            if (typeof item === 'string' || (0, isNumber_1.default)(item)) {
                result.push((0, toString_1.default)(item));
            }
            if ((0, isSymbol_1.default)(item)) {
                result.push(item);
            }
            if (Array.isArray(item) || (0, validCheck_1.isArguments)(item)) {
                result.push.apply(result, __spreadArray([], __read(item), false));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (savedProps_1_1 && !savedProps_1_1.done && (_a = savedProps_1.return)) _a.call(savedProps_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}
exports.getFilters = getFilters;
/**
 * 获取输入对象的keys，包括以Symbol定义的属性key
 * @param input
 */
function getObjectKeys(input) {
    var result = __spreadArray([], __read(Object.keys(input)), false);
    if (!(0, isNumber_1.default)(input) && !(0, isString_1.default)(input) && !Array.isArray(input)) {
        result = (0, concat_1.default)(result, Object.getOwnPropertySymbols(input));
    }
    return result;
}
exports.getObjectKeys = getObjectKeys;
function setPropsToResult(input, filters, result, deleteKey) {
    if (deleteKey === void 0) { deleteKey = false; }
    var filterList = __spreadArray([], __read(filters), false);
    getObjectKeys(input).forEach(function (eachKey) {
        if (filterList.includes(eachKey)) {
            result[eachKey] = input[eachKey];
            if (deleteKey) {
                (0, pull_1.default)(filterList, [eachKey]);
            }
        }
    });
    return filterList;
}
/**
 * 获取对象的嵌套属性的值
 * @param input
 * @param key
 */
function getNestedValue(input, key) {
    var newObj = {};
    var nestedKeys = (0, isSymbol_1.default)(key) ? [key] : key.split('.');
    if (nestedKeys.length > 1) {
        var topKey = nestedKeys.shift();
        var nestedValue = getNestedValue(input[topKey], nestedKeys.join('.'));
        newObj[topKey] = nestedValue;
        return newObj;
    }
    if (Object.prototype.hasOwnProperty.call(input, key)) {
        newObj[key] = input[key];
    }
    return newObj;
}
exports.getNestedValue = getNestedValue;
function mergeNestedObjToResult(target, other) {
    var e_2, _a;
    var targetToString = Object.prototype.toString.call(target);
    var otherToString = Object.prototype.toString.call(target);
    if (targetToString === '[object Object]' && otherToString === '[object Object]') {
        try {
            for (var _b = __values(Object.entries(other)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), key = _d[0], val = _d[1];
                var test_1 = !target[key];
                target[key] = test_1 ? val : mergeNestedObjToResult(target[key], val);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    else {
        return other;
    }
    return target;
}
function setNestedPropsToResult(filters, input, result) {
    if (filters.length > 0) {
        filters.forEach(function (eachKey) {
            var newObj = getNestedValue(input, eachKey);
            var topKey = Object.keys(newObj)[0];
            if (!Object.prototype.hasOwnProperty.call(result, topKey)) {
                Object.assign(result, newObj);
            }
            else {
                mergeNestedObjToResult(result, newObj);
            }
        });
    }
}
/**
 * 检查对象属性是否嵌套
 * @param input
 */
function checkIsNestedObject(input) {
    var e_3, _a;
    var objKeys = getObjectKeys(input);
    try {
        for (var objKeys_1 = __values(objKeys), objKeys_1_1 = objKeys_1.next(); !objKeys_1_1.done; objKeys_1_1 = objKeys_1.next()) {
            var eachKey = objKeys_1_1.value;
            if (Object.prototype.toString.call(input[eachKey]) === '[object Object]') {
                return true;
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (objKeys_1_1 && !objKeys_1_1.done && (_a = objKeys_1.return)) _a.call(objKeys_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return false;
}
exports.checkIsNestedObject = checkIsNestedObject;
/**
 * 处理有嵌套属性的对象、及其原型对象
 * @param input
 * @param filterList
 */
function processNestedObject(input, filterList) {
    var result = {};
    var filters = setPropsToResult(input, filterList, result, true);
    setNestedPropsToResult(filters, input, result);
    // input的原型对象
    var protoTypeOfObj = Object.getPrototypeOf(input);
    if (checkIsNestedObject(protoTypeOfObj)) {
        filters = setPropsToResult(protoTypeOfObj, filterList, result, true);
        setNestedPropsToResult(filters, protoTypeOfObj, result);
    }
    else {
        setPropsToResult(protoTypeOfObj, filterList, result);
    }
    return result;
}
/**
 * 处理普通对象、及其原型对象
 * @param input
 * @param filterList
 */
function processCommonObject(input, filterList) {
    var result = {};
    setPropsToResult(input, filterList, result);
    // input的原型对象
    var protoTypeOfObj = Object.getPrototypeOf(input);
    if (!checkIsNestedObject(protoTypeOfObj)) {
        setPropsToResult(protoTypeOfObj, filterList, result);
    }
    // input的原型对象存在嵌套属性
    var filters = setPropsToResult(protoTypeOfObj, filterList, result, true);
    setNestedPropsToResult(filters, protoTypeOfObj, result);
    return result;
}
/**
 * 创建一个从 object 中选中的属性的对象，返回被保留属性后的新对象
 * @param input 来源对象
 * @param savedProps 保留的属性
 */
function pick(input) {
    var savedProps = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        savedProps[_i - 1] = arguments[_i];
    }
    if (input === null || input === undefined) {
        return {};
    }
    var filterList = getFilters(savedProps);
    if (!checkIsNestedObject(input)) {
        return processCommonObject(input, filterList);
    }
    return processNestedObject(input, filterList);
}
exports.default = pick;
