"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseArraySort_1 = require("./common/baseArraySort");
var identity_1 = __importDefault(require("./identity"));
/**
 * 对指定集合内容进行升序（ASC）排序，并返回排序的数组。
 * 关于迭代器：
 * 排序的值则是来自 iteratees 来遍历对象生成的值，如果迭代器是一个对象或者字符串，则会以这个对象或者字符串为key，找到集合对象中的值。
 * 如果迭代器为函数或者函数集合，则该函数会接受集合对象中的每个对象，并且返回自定义的值；多个函数则意味着排序时按照多个值排序。
 * @param collection 计算排序的集合
 * @param iteratees 迭代器，默认不传入的时候，使用的是 value => value 函数替代。
 */
function sortBy(collection) {
    var e_1, _a;
    var iteratees = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        iteratees[_i - 1] = arguments[_i];
    }
    var result = [].concat(collection);
    if (!Array.isArray(collection)) {
        var keys = Object.keys(collection);
        result = [];
        try {
            for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var key = keys_1_1.value;
                result.push(collection[key]);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    var calcIteratee = iteratees;
    if (iteratees == null || iteratees.length === 0) {
        calcIteratee = [identity_1.default];
    }
    else {
        // 清理其中的 null/undefined 迭代器，全部换成 entity
        var len = iteratees.length;
        for (var i = 0; i < len; i++) {
            if (calcIteratee[i] == null) {
                calcIteratee[i] = identity_1.default;
            }
        }
    }
    return (0, baseArraySort_1.arraySort)(result, calcIteratee, ['asc']);
}
exports.default = sortBy;
