export interface StrTruncateOption {
    /**
     * 允许的最大长度。这是加上替代字符串之后
     * 不是 number 情况下，会将其转换成 number 使用
     */
    length?: number | any;
    /**
     * 超出后的代替字符。
     */
    omission?: string;
    /**
     * 截断点。
     */
    separator?: RegExp | string;
}
/**
 * 截断string字符串，如果字符串超出了限定的最大值。 被截断的字符串后面会以 omission 代替，omission 默认是 "..."。
 * @param str 要截断的字符串
 * @param options 为 Object 对象，截断的选项。<pre>
 *   options.length 默认值`30`，整形，允许的最大长度。
 *   options.omission 默认值 `...`，字符串类型，超出后的代替字符串
 *   options.separator 无默认值， RegExp | string 类型，截断点。
 *   </pre>
 * @returns 按照要求截断后的字符串
 * @example
 * ```ts
 * _.truncate('hi-diddly-ho there, neighborino');
 * // => 'hi-diddly-ho there, neighbo...'
 *
 * _.truncate('hi-diddly-ho there, neighborino', {
 *   'length': 24,
 *   'separator': ' '
 * });
 * // => 'hi-diddly-ho there,...'
 *
 * _.truncate('hi-diddly-ho there, neighborino', {
 *   'length': 24,
 *   'separator': /,? +/
 * });
 * // => 'hi-diddly-ho there...'
 *
 * _.truncate('hi-diddly-ho there, neighborino', {
 *   'omission': ' [...]'
 * });
 * // => 'hi-diddly-ho there, neig [...]'
 * ```
 */
export default function truncate(str?: any, options?: any): any;
