import { Level } from 'log4js';
import { HvigorCliOptions } from '../../util/options/hvigor-cli-options.js';
/**
 * 保存cli生命周期中常用的全局数据
 *
 * @since 2022/8/17
 */
declare class GlobalData {
    cliEnv: any;
    cliOpts: HvigorCliOptions;
    init(cliEnv: any, cliOpts: HvigorCliOptions): void;
}
export declare const globalData: GlobalData;
export declare enum AnalyzeMode {
    DEFAULT = 0,
    VERBOSE = 1,
    FALSE = 2
}
export interface StartParameters {
    hvigorfileTypeCheck: boolean;
    parallelExecution: boolean;
    incrementalExecution: boolean;
    printStackTrace: boolean;
    daemon: boolean;
    analyze: AnalyzeMode;
    logLevel: Level;
    enableSignTask: boolean;
    poolMaxCoreSize?: number;
    poolCacheCapacity?: number;
    poolCacheTtl?: number;
    skipNativeIncremental: boolean;
}
export declare const defaultStartParameters: StartParameters;
export declare let startParameters: StartParameters;
export interface StartEnvironment {
    nodeHome: string;
    hvigorUserHome: string;
}
export declare const defaultStartEnvironment: StartEnvironment;
export declare let startEnvironment: StartEnvironment;
export declare function initStartData(hvigorCliOptions?: HvigorCliOptions): void;
export declare function resetStartData(): void;
export {};
