"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.WorkerPoolImpl=void 0;const noop_js_1=require("../../../../common/util/noop.js"),hvigor_log_js_1=require("../../../log/hvigor-log.js"),duration_event_js_1=require("../../../metrics/event/duration-event.js"),log_event_js_1=require("../../../metrics/event/log-event.js"),metric_service_js_1=require("../../../metrics/metric-service.js"),cpu_js_1=require("../../../util/cpu.js"),global_data_js_1=require("../../data/global-data.js"),constant_js_1=require("../constant/constant.js"),dispatcher_factory_js_1=require("../dispatcher/dispatcher-factory.js"),dispatcher_type_js_1=require("../enum/dispatcher-type.js"),pool_state_js_1=require("../enum/pool-state.js"),priority_js_1=require("../enum/priority.js"),log_service_impl_js_1=require("../log-collection/log-service-impl.js"),itcb_js_1=require("../model/itcb.js"),work_js_1=require("../model/work.js"),cluster_priority_ready_queue_js_1=require("../ready-queue/cluster-priority-ready-queue.js"),tcb_store_js_1=require("../store/tcb-store.js"),worker_manager_impl_js_1=require("../worker-manager/worker-manager-impl.js"),pool_config_js_1=require("./pool-config.js"),log=hvigor_log_js_1.HvigorLogger.getLogger("hvigor-worker-pool");class WorkerPoolImpl{constructor(e){log.debug("Worker pool is initialized with config: ",e),this.poolConfig=e,this.resident=!0,this.state=pool_state_js_1.PoolState.INIT,this.dispatcher=dispatcher_factory_js_1.DispatcherFactory.getDispatcher(dispatcher_type_js_1.DispatcherType.LOOP_PRIORITY),this.logService=new log_service_impl_js_1.LogServiceImpl,this.logService.start(),this.workerManager=new worker_manager_impl_js_1.WorkerManagerImpl(e,((e,t)=>this.dispatcher.dispatch(this.logService,this.readyQueue,e,t)),(e=>{this.logService.addLog(e)})),this.readyQueue=new cluster_priority_ready_queue_js_1.ClusterPriorityReadyQueue(this.workerManager.getMaxPoolNum()),(0,cpu_js_1.startMonitor)(),this.state=pool_state_js_1.PoolState.RUNNING,this.checkPoolState()||this.terminate()}setResident(e){this.resident=e}isResident(){return this.resident}getMaxPoolNum(){return this.workerManager.getMaxPoolNum()}getMinPoolNum(){return this.workerManager.getMinPoolNum()}static getInstance(e){return WorkerPoolImpl.instance&&WorkerPoolImpl.instance.state!==pool_state_js_1.PoolState.TERMINATED?(0,pool_config_js_1.isSamePoolConfig)(WorkerPoolImpl.instance.getPoolConfig(),e)||(log.debug("Current worker pool does not match this config, create a new worker pool."),log.debug("Current pool config: ",WorkerPoolImpl.instance.poolConfig),log.debug("New pool config: ",e),WorkerPoolImpl.instance.terminate().then((e=>log.debug(`worker pool terminated with: ${e}`))),WorkerPoolImpl.instance=new WorkerPoolImpl(e)):(log.debug("Since there is no instance or instance is terminated, create a new worker pool."),WorkerPoolImpl.instance=new WorkerPoolImpl(e)),WorkerPoolImpl.instance}getLog(e){return this.logService.getLog(e)}clearLog(e){return this.logService.clear(e)}getState(){return this.state}setMaxIdleTime(e){this.workerManager.setMaxIdleTime(e)}setRecycleInterval(e){this.workerManager.setRecycleInterval(e)}setErrorCallback(e){this.workerManager.setErrorCallback(e)}setState(e){pool_state_js_1.transitionMap.get(this.state).has(e)&&(this.state=e,this.state===pool_state_js_1.PoolState.STOP&&this.readyQueue.clear())}warmUp(e){if(this.state!==pool_state_js_1.PoolState.RUNNING)return!1;const t=new work_js_1.Work(priority_js_1.Priority.FIRST,void 0,e),o=new itcb_js_1.ITCB(t,noop_js_1.noop,!1,[],(()=>{this.readyQueue.update(t)}),"","","");return tcb_store_js_1.TcbStore.add(o),this.readyQueue.push(t),this.dispatcher.dispatch(this.logService,this.readyQueue,this.workerManager),!0}submit(e,t,o){var r;const s=new work_js_1.Work(null!==(r=null==o?void 0:o.priority)&&void 0!==r?r:priority_js_1.Priority.MEDIUM,this.filterTargetWorkers(null==o?void 0:o.targetWorkers),t,null==o?void 0:o.workInput,null==o?void 0:o.hasSideEffects,null==o?void 0:o.preludeDeps);return this.submitWork(e,s,o)}filterTargetWorkers(e){if(!e)return e;const t=new Set,o=[];for(const r of e)Number.isInteger(r)&&!t.has(r)&&r<this.workerManager.getMaxPoolNum()&&r>=0&&(t.add(r),o.push(r));return o}submitWork(e,t,o){if(!this.workSubmissionCanBeAccepted(t))return log.debug(`Task ${e.getPath()}'s work:${t.getId()} will not be executed in worker pool.`),itcb_js_1.ITCB.getDefaultRejectTcb(e,t,o);const r=`${e.getName()} work[${t.getId()}]`;log.debug(`${r} is submitted.`);const s=this.initTcb(e,t,o);return this.readyQueue.push(t),log.debug(`${r} is pushed to ready queue.`),this.dispatcher.dispatch(this.logService,this.readyQueue,this.workerManager)?log.debug(`${r} is dispatched.`):log.debug(`${r} is not dispatched.`),s}workSubmissionCanBeAccepted(e){const t=global_data_js_1.startParameters.parallelExecution,o=this.state===pool_state_js_1.PoolState.RUNNING,r=void 0===e.getTargetWorkers()||0!==e.getTargetWorkers().length;return t&&o&&r}initTcb(e,t,o){var r,s;const i=new itcb_js_1.ITCB(t,null!==(r=null==o?void 0:o.callback)&&void 0!==r?r:noop_js_1.noop,null==o?void 0:o.useReturnVal,null!==(s=null==o?void 0:o.callbackInput)&&void 0!==s?s:[],(()=>{this.readyQueue.update(t)}),e.getNode().getName(),e.getName(),e.getPath()),a=e,n=new Promise(((t,o)=>{i.on(constant_js_1.PoolConstant.WORK_DONE,(o=>{log.debug(`${e.getName()} work[${o}] done.`),this.recordDurationEvent(a,o,i,!0),t(!0)})),i.on(constant_js_1.PoolConstant.WORK_ERROR,(t=>{log.debug(`${e.getName()} work[${t.id}] failed.`),this.recordDurationEvent(a,t.id,i,!1),o(t.error)}))}));return a.pendingPromises.add(n),a.addSubDurationEvent(t.getId()),tcb_store_js_1.TcbStore.add(i),i}recordDurationEvent(e,t,o,r){const s=e.getSubDurationEvent(t);null==s||s.setTid(`Worker${o.getWorkerId()}`),null==s||s.start(duration_event_js_1.DurationEventState.RUNNING,o.getStartTime()),null==s||s.stop(r?duration_event_js_1.DurationEventState.SUCCESS:duration_event_js_1.DurationEventState.FAILED,o.getEndTime()),null==s||s.setLog(null==s?void 0:s.getName(),r?log_event_js_1.MetricLogType.INFO:log_event_js_1.MetricLogType.ERROR,null==s?void 0:s.getDescription()),this.updateTid(s)}updateTid(e){e&&e.getChildren().forEach((t=>{const o=metric_service_js_1.MetricService.getInstance().getEventById(t);this.updateTid(null==o?void 0:o.setTid(e.getTid()))}))}terminate(){return new Promise(((e,t)=>{this.state===pool_state_js_1.PoolState.TERMINATED&&e(!0),this.state===pool_state_js_1.PoolState.RUNNING&&this.setState(pool_state_js_1.PoolState.STOP),this.state===pool_state_js_1.PoolState.STOP||this.state===pool_state_js_1.PoolState.CLOSE?(log.debug("Current worker pool is stopped or closed."),this.logService.end(),this.readyQueue.clear(),this.workerManager.clear((()=>{(0,cpu_js_1.endMonitor)().then((()=>{this.setState(pool_state_js_1.PoolState.TERMINATED),log.debug("Current worker pool is terminated."),e(!0)}))}))):(log.debug("Current worker pool has been terminated."),(0,cpu_js_1.endMonitor)().then((()=>e(!1))))}))}recycle(){return new Promise(((e,t)=>{this.readyQueue.clear(),this.workerManager.cleanUp((()=>e(!0)))}))}checkPoolState(){return!(this.getMaxPoolNum()<1||this.getMaxPoolNum()<this.getMinPoolNum())}getPoolConfig(){return this.poolConfig}}exports.WorkerPoolImpl=WorkerPoolImpl;