'use strict';
Object.defineProperty(exports, '__esModule', { value: true });
const daemon_cache_service_js_1 = require('../../../../src/base/daemon/registry/daemon-cache-service.d.ts');
const daemon_info_js_1 = require('../../../../src/base/daemon/registry/daemon-info.d.ts');
const hvigor_log_js_1 = require('../../../../src/base/log/hvigor-log.d.ts');
const hash_util_js_1 = require('../../../../src/base/util/hash-util.d.ts');
const daemonCacheJsonPath = process.argv[2];
const _log = hvigor_log_js_1.HvigorLogger.getLogger();
const daemonCacheService = new daemon_cache_service_js_1.DaemonCacheService(daemonCacheJsonPath, _log);
const defaultDaemonInfo = {
  address: '',
  cwdPath: '',
  hvigorVersion: '',
  nodeParams: (0, hash_util_js_1.hash)(process.execArgv.toString()),
  nodeVersion: '',
  pid: 0,
  port: 0,
  state: daemon_info_js_1.DaemonState.IDLE,
  lastUsedTime: Date.now()
};
Array.from(Array.of(100).keys()).forEach(i => {
  daemonCacheService.set(i.toString(), {
    keyId: i.toString(),
    ...defaultDaemonInfo
  });
});
Array.from(Array.of(100).keys()).forEach(i => {
  daemonCacheService.get(i.toString());
  return daemonCacheService.remove(i.toString());
});

// # sourceMappingURL=test-lock-cache.js.map
