import * as execa from 'execa';
export type hvigorOptions = {
    mode?: string;
    module?: string | string[];
    log?: string;
    require?: string;
    v?: boolean;
    version?: boolean;
    sync?: boolean;
    tasks: string | string[];
    noParallel?: boolean;
    noIncremental?: boolean;
    noDaemon?: boolean;
};
export type initOption = {
    keepTemp?: boolean;
    sign?: boolean;
};
/**
 * 用临时文件夹初始化一个临时测试工程模板
 *
 * @param from 要使用的模板测试用例工程
 * @param cb 要执行的测试逻辑方法，接收一个temp参数为临时文件夹的根目录
 * @param options
 * @param projectRootPathArg
 * @returns {Promise<void>}
 */
export declare function initByProject(from: string, cb: (temp: string) => Promise<void>, options?: initOption, projectRootPathArg?: string): Promise<void>;
/**
 * 返回package的根目录
 *
 * @returns {string} package的根目录
 */
export declare function appRoot(dirname?: string): string;
/**
 * 初始化命令
 *
 * @param {hvigorOptions} options 传入命令参数
 * @returns {string[]} commands 生成命令行指令
 */
export declare function initExecuteCommand(options: hvigorOptions): string[];
/**
 * 传入命令和工程根目录，执行hvigor任务
 *
 * @param {string} path 工程根目录
 * @param {string[]} commands 执行命令
 * @returns {Promise<execa.ExecaChildProcess>}
 */
export declare function runHvigor(path: string, commands: string[]): execa.ExecaChildProcess;
/**
 * 传入命令和工程根目录，执行hvigor任务
 *
 * @param {string} path 工程根目录
 * @param {string[]} commands 执行命令
 * @returns {Promise<string | undefined>}
 */
export declare function runHvigorReturnResult(path: string, commands: string[]): Promise<string | undefined>;
