"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runHvigorReturnResult = exports.runHvigor = exports.initExecuteCommand = exports.appRoot = exports.initByProject = void 0;
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
 */
const execa = __importStar(require("execa"));
const path_1 = require("path");
const fs = __importStar(require("fs-extra"));
const json5_reader_1 = require("../../../../src/base/util/json5-reader");
const index_1 = require("../../../../index");
index_1.hvigor.getProject();
const debugMode = false;
/**
 * 用临时文件夹初始化一个临时测试工程模板
 *
 * @param from 要使用的模板测试用例工程
 * @param cb 要执行的测试逻辑方法，接收一个temp参数为临时文件夹的根目录
 * @param options
 * @param projectRootPathArg
 * @returns {Promise<void>}
 */
async function initByProject(from, cb, options, projectRootPathArg) {
    const projectRootPath = projectRootPathArg === undefined ? appRoot() : projectRootPathArg;
    const initOption = {
        keepTemp: false,
        sign: true,
        ...options
    };
    await fs.ensureDir((0, path_1.resolve)(projectRootPath, 'test', 'temp'));
    const temp = await fs.mkdtemp((0, path_1.resolve)(projectRootPath, 'test', 'temp', 'temp_'));
    try {
        await fs.copy((0, path_1.resolve)(projectRootPath, 'test', 'cli', 'resource', 'application', from), temp);
        await Promise.all([runNpmInstall(temp)]);
        await cb(temp);
    }
    finally {
        if (!initOption.keepTemp) {
            await fs.remove(temp);
        }
    }
}
exports.initByProject = initByProject;
/**
 * 返回package的根目录
 *
 * @returns {string} package的根目录
 */
function appRoot(dirname = __dirname) {
    while (!fs.existsSync((0, path_1.resolve)(dirname, 'package.json'))) {
        dirname = (0, path_1.resolve)(dirname, '..');
    }
    return dirname;
}
exports.appRoot = appRoot;
/**
 * 执行项目的npm install
 *
 * @param {string} path
 * @returns {Promise<execa.ExecaChildProcess>}
 */
async function runNpmInstall(path) {
    const buildProfile = json5_reader_1.Json5Reader.getJson5Obj((0, path_1.resolve)(path, 'build-profile.json5'));
    const srcPaths = [path, ...buildProfile.modules.map((unit) => {
            return (0, path_1.resolve)(path, unit['srcPath']);
        })];
    await Promise.all(srcPaths.map((srcPath) => {
        return execa.command('npm install', {
            cwd: srcPath
        });
    }));
}
/**
 * 初始化命令
 *
 * @param {hvigorOptions} options 传入命令参数
 * @returns {string[]} commands 生成命令行指令
 */
function initExecuteCommand(options) {
    const commands = [];
    const { mode, module, log, require, version, v, sync, tasks, noParallel, noIncremental, noDaemon } = options;
    if (mode) {
        commands.push('-m');
        commands.push(mode);
    }
    if (module) {
        commands.push('-p');
        if (typeof module === 'string') {
            commands.push(`module=${module}`);
        }
        else {
            commands.push(`module=${module.join(',')}`);
        }
    }
    if (log) {
        commands.push(`-${log}`);
    }
    else {
        commands.push('-d');
    }
    if (require) {
        commands.push('--require');
        commands.push(require);
    }
    if (v) {
        commands.push('--version');
    }
    if (version) {
        commands.push('version');
    }
    if (sync) {
        commands.push('-s');
    }
    if (noParallel) {
        commands.push('--no-parallel');
    }
    if (noIncremental) {
        commands.push('--no-incremental');
    }
    if (noDaemon) {
        commands.push('--no-daemon');
    }
    if (typeof tasks === 'string') {
        commands.push(tasks);
    }
    else {
        commands.push(tasks.join(' '));
    }
    return commands;
}
exports.initExecuteCommand = initExecuteCommand;
/**
 * 传入命令和工程根目录，执行hvigor任务
 *
 * @param {string} path 工程根目录
 * @param {string[]} commands 执行命令
 * @returns {Promise<execa.ExecaChildProcess>}
 */
function runHvigor(path, commands) {
    const process = execa.node(require.resolve('@ohos/hvigor/bin/hvigor-simple.js'), commands, {
        cwd: path,
    });
    if (debugMode) {
        console.log('===================');
        console.log(process.stdout);
        console.log(process.stderr);
    }
    return process;
}
exports.runHvigor = runHvigor;
/**
 * 传入命令和工程根目录，执行hvigor任务
 *
 * @param {string} path 工程根目录
 * @param {string[]} commands 执行命令
 * @returns {Promise<string | undefined>}
 */
async function runHvigorReturnResult(path, commands) {
    let result;
    try {
        await runHvigor(path, commands);
    }
    catch (e) {
        result = e.stack;
        if (debugMode) {
            console.log(result);
        }
    }
    return result;
}
exports.runHvigorReturnResult = runHvigorReturnResult;
//# sourceMappingURL=common.js.map