
# 鸿蒙播放器 - 最佳实践接入流程
本Demo提供两个模式`演示Demo`与`Beta测试Demo`。

## scenes 场景
本Demo目前提供如下使用场景与功能实现的最佳实践方案。（场景仍在不断扩充完善中，感谢您的理解。）
- 全屏、后台播放。常见播放功能
- VideoComponent。通用的视频播放基础组件，帮助您实现自定义、可复用的播放组件。
- 多实例播放。新闻轮播场景。 multi_player
- 原子接入。最简单的接入方式，提供最大的自定义程度。 single_player (极简接入)
- 短视频。列表播放，满足一般的滑动场景。 swiper_short_videos 列表播放
- 短剧 demo。简易的微短剧Demo。 swiper_theater
- 播放器UI实现。配合VideoComponent实现简易播放场景。

## 开启Beta测试Demo
- 本Demo提供两个模式`演示Demo`与`Beta测试Demo`。
- 默认为`演示Demo`模式，提供成熟、推荐的最佳实践用法。我们建议您参考这部分代码进行开发。
- 如果您需要查看更多，可以选择开启`Beta测试Demo`进行体验。
- 开启方式：在外层壳工程`AliplayerHarmonyOSNextDemo`目录下，修改`build-profile`：按如下方式将demoType写入"demo"
```
"products": [
  {
    "name": "default",
    "signingConfig": "default",
    "compatibleSdkVersion": "5.0.0(12)",
    "runtimeOS": "HarmonyOS",
    "buildOption": {
      "arkOptions": {
        "buildProfileFields": {
          "demoType": ""
          // 'debug' 表示测试demo  空为演示demo
        }
      }
    }
  }
],
```
## 目录介绍
- 工程目录的配置与依赖库相关介绍，请参阅壳工程的`README.md`文件。[参阅链接](./../README.md)
- 此处仅介绍具体`src`目录下，各个场景最佳实践的代码所在位置。
```
|  |-- amdemos-player-ohos-listapp # demo目录
|    |--- src # 源代码
|       |---- main # 代码目录
|          |----- ets # 业务代码
|             |------ common        # 公共常量、Utils类
|                |------- Constants     # 全局定义、Url地址
|             |------ controller    # 业务方法、类
|                |------- BackstagePlaybackController # 后台播放实现方案       - 最佳实践
|                |------- ListPlayerVideoController   # AliListPlayer实例管理 - 最佳实践
|                |------- Request                     # http请求方式
|                |------- UIController                # UI实现方式            - 最佳实践
|                |------- VideoController             # AliPlayer实例管理方式  - 最佳实践
|             |------ entryability  # 鸿蒙原生应用入口
|             |------ pages         # Beta测试Demo
|                |------- list_player
|                   |-------- ListPlayerSwiperPage # 列表播放页面、滑动播放、短剧 - 最佳实践 
|             |------ present       # 演示Demo
|                |------- scenes
|                   |-------- multi_player
|                       |--------- mediumVideosPage   # 多实例播放、信息流     - 最佳实践
|                   |-------- single_player
|                       |--------- longVideosPage     # 单视频播放、UI实现方式 - 最佳实践
|                       |--------- shortVideosPage    # 极简接入、最简接入方式  - 最佳实践
|                   |-------- swiper_theater
|                       |--------- theaterPage        # 微短剧Demo
|             |------ view          # 业务UI组件
|                |------- core
|                   |-------- VideoComponent       # 通用的基础播放组件，用于复用  - 最佳实践
```

