import premierlibrary from 'libpremierlibrary.so';
import { ErrorInfo } from '../player/bean/ErrorInfo';
import { findErrorCodeByValue, PlayerErrorCode } from '../player/bean/PlayerErrorCode';
import { ObjCreateHelper } from '../utils/ObjCreateHelper';
export class MediaLoaderV2 {
    constructor() {
        this.listenerMap = new Map();
        this.objHelper = new ObjCreateHelper();
        this.onError = (z5, a6, b6, c6) => {
            console.log('MediaLoaderV2 onError called, taskId: ' + z5 + " urlOrVid: " + a6 + " code: " + b6 + " msg: " + c6);
            const d6 = this.listenerMap.get(z5);
            if (d6) {
                const e6 = findErrorCodeByValue(b6);
                const f6 = new ErrorInfo();
                f6.setCode(e6);
                f6.setMsg(c6);
                d6.onError(z5, a6, f6);
            }
            if (b6 != PlayerErrorCode.MEDIALOADER_ERROR_ADDED) {
                MediaLoaderV2.getInstance().cancelTask(z5);
            }
        };
        this.onCompleted = (w5, x5) => {
            console.log('MediaLoaderV2 onCompleted called, taskId: ' + w5 + " urlOrVid: " + x5);
            const y5 = this.listenerMap.get(w5);
            if (y5) {
                y5.onCompleted(w5, x5);
            }
            this.listenerMap.delete(w5);
            MediaLoaderV2.getInstance().cancelTask(w5);
        };
        this.onCanceled = (t5, u5) => {
            console.log('MediaLoaderV2 onCanceled called, taskId: ' + t5 + " urlOrVid: " + u5);
            const v5 = this.listenerMap.get(t5);
            if (v5) {
                v5.onCanceled(t5, u5);
            }
            this.listenerMap.delete(t5);
        };
        premierlibrary.nMediaLoaderV2Construct(this);
    }
    static getInstance() {
        if (!MediaLoaderV2.sInstance) {
            MediaLoaderV2.sInstance = new MediaLoaderV2();
        }
        return MediaLoaderV2.sInstance;
    }
    addTask(n5, o5) {
        const p5 = premierlibrary.nMediaLoaderV2AddTask(n5);
        this.listenerMap.set(p5, o5);
        return p5;
    }
    cancelTask(m5) {
        premierlibrary.nMediaLoaderV2CancelTask(m5);
    }
    pauseTask(l5) {
        premierlibrary.nMediaLoaderV2PauseTask(l5);
    }
    resumeTask(k5) {
        premierlibrary.nMediaLoaderV2ResumeTask(k5);
    }
}
